/*
 * Decompiled with CFR 0.152.
 */
package thorwin.math.accelerator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import thorwin.math.accelerator.CpuID;
import thorwin.math.accelerator.Order;
import thorwin.math.accelerator.Transpose;

public final class Blas {
    private static String getSupportedMicroarchitecture() {
        switch (Blas.getMicroarchitecture()) {
            case "SKYLAKE": 
            case "BROADWELL": 
            case "HASWELL": {
                return "HASWELL";
            }
            case "SANDYBRIDGE": 
            case "IVYBRIDGE": {
                return "SANDYBRIDGE";
            }
            case "BULLDOZER": {
                return "BULLDOZER";
            }
            case "PILEDRIVER": 
            case "STEAMROLLER": 
            case "EXCAVATOR": {
                return "PILEDRIVER";
            }
        }
        return "GENERIC";
    }

    private static String getMicroarchitecture() {
        Optional<CpuID> cpuid = CpuID.getCpuID();
        if (cpuid.isPresent()) {
            int family = cpuid.get().getFamily();
            int model = cpuid.get().getModel();
            switch (family) {
                case 6: {
                    switch (model) {
                        case 42: 
                        case 45: {
                            return "SANDYBRIDGE";
                        }
                        case 58: 
                        case 62: {
                            return "IVYBRIDGE";
                        }
                        case 60: 
                        case 63: 
                        case 69: 
                        case 70: {
                            return "HASWELL";
                        }
                        case 61: 
                        case 71: 
                        case 79: 
                        case 86: {
                            return "BROADWELL";
                        }
                        case 78: 
                        case 94: {
                            return "SKYLAKE";
                        }
                    }
                    break;
                }
                case 21: {
                    if (model < 15) {
                        return "BULDOZER";
                    }
                    if (model >= 16 && model <= 47) {
                        return "PILEDRIVER";
                    }
                    if (model >= 48 && model <= 79) {
                        return "STEAMROLLER";
                    }
                    if (model < 96 || model > 127) break;
                    return "EXCAVATOR";
                }
            }
        }
        return "GENERIC";
    }

    public static void dgemm(Order order, Transpose transa, Transpose transb, int m, int n, int k, double alpha, double[] a, double[] b, double beta, double[] c) {
        Blas.dgemm(order.value(), transa.value(), transb.value(), m, n, k, alpha, a, transa == Transpose.NO_TRANSPOSE ? k : m, b, transb == Transpose.NO_TRANSPOSE ? n : k, beta, c, n);
    }

    private static native void dgemm(int var0, int var1, int var2, int var3, int var4, int var5, double var6, double[] var8, int var9, double[] var10, int var11, double var12, double[] var14, int var15);

    public static void daxpy(double da, double[] dx, double[] dy) {
        if (dx.length != dy.length) {
            throw new IllegalArgumentException("arrays should have equal lengths");
        }
        Blas.daxpy(dx.length, da, dx, 1, dy, 1);
    }

    private static native void daxpy(int var0, double var1, double[] var3, int var4, double[] var5, int var6);

    static {
        try {
            String extension = ".so";
            if (System.getProperty("os.name").contains("Mac")) {
                extension = ".jnilib";
            }
            byte[] buffer = new byte[1024];
            File file = File.createTempFile("lib", extension);
            file.deleteOnExit();
            String microarchitecture = Blas.getSupportedMicroarchitecture();
            try (InputStream in = Blas.class.getResourceAsStream("Blas-" + microarchitecture + extension);
                 FileOutputStream out = new FileOutputStream(file);){
                int len = in.read(buffer);
                while (len > 0) {
                    out.write(buffer, 0, len);
                    len = in.read(buffer);
                }
            }
            System.load(file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

