/******************************************************************************
 * Copyright (C) 2015 Sebastiaan R. Hogenbirk                                 *
 *                                                                            *
 * This program is free software: you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public License as published by       *
 * the Free Software Foundation, either version 3 of the License, or          *
 * (at your option) any later version.                                        *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License          *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.      *
 ******************************************************************************/

package thorwin.math.accelerator;

/**
 * Pack order.
 */
public enum Order {
  ROW_MAJOR,
  COLUMN_MAJOR;

  /**
   * Returns the parameter value.
   * @return CBLAS_ORDER value
   */
  int value() {
    switch (this) {
      case ROW_MAJOR:
        return 101;
      case COLUMN_MAJOR:
        return 102;
      default:
        throw new IllegalStateException();
    }
  }
}
