/******************************************************************************
 * Copyright (C) 2015 Sebastiaan R. Hogenbirk                                 *
 * * This program is free software: you can redistribute it and/or modify * it
 * under the terms of the GNU General Public License as published by * the Free
 * Software Foundation, either version 3 of the License, or * (at your option)
 * any later version. * * This program is distributed in the hope that it will
 * be useful, * but WITHOUT ANY WARRANTY; without even the implied warranty of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the * GNU General
 * Public License for more details. * * You should have received a copy of the
 * GNU General Public License * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>. *
 ******************************************************************************/

package thorwin.math.accelerator;

import thorwin.math.spi.MatrixOperationsProvider;


/**
 * Matrix context that creates BLAS matrices where suitable.
 */
public final class BlasMatrixOperationsProvider extends MatrixOperationsProvider {

  @Override
  public void dgemm(double[] a,
                    double[] b,
                    double[] c,
                    int m,
                    int n,
                    int k,
                    boolean ta,
                    boolean tb,
                    double alpha,
                    double beta) {
    Blas.dgemm(Order.ROW_MAJOR,
               ta ? Transpose.TRANSPOSE : Transpose.NO_TRANSPOSE,
               tb ? Transpose.TRANSPOSE : Transpose.NO_TRANSPOSE,
               m,
               n,
               k,
               alpha,
               a,
               b,
               beta,
               c);
  }
}
