/*
 * Decompiled with CFR 0.152.
 */
package com.globalros.tftp.common;

import com.globalros.tftp.common.ACK;
import com.globalros.tftp.common.ERROR;
import com.globalros.tftp.common.TFTPPacket;
import com.globalros.tftp.common.TFTPSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class TFTPUtils {
    private static final Logger tftpLog = Logger.getLogger((Class)(class$com$globalros$tftp$common$TFTPUtils == null ? (class$com$globalros$tftp$common$TFTPUtils = TFTPUtils.class$("com.globalros.tftp.common.TFTPUtils")) : class$com$globalros$tftp$common$TFTPUtils));
    static /* synthetic */ Class class$com$globalros$tftp$common$TFTPUtils;

    private TFTPUtils() {
    }

    public static ACK dataTransfer(TFTPSocket tftpSock, ACK send, ACK recv) throws IOException {
        int retransmits = 0;
        int spamcount = 0;
        boolean stuffedLink = false;
        int timeout = tftpSock.getSocketTimeOut();
        tftpSock.write(send);
        boolean receiving = true;
        while (receiving) {
            TFTPPacket tftpP = tftpSock.read();
            if (tftpP == null) {
                if (recv == null) {
                    return null;
                }
                if (retransmits++ > 5) {
                    throw new IOException(TFTPUtils.getClient(tftpSock) + " Maximum retransmit count exceeded");
                }
                tftpLog.debug((Object)(TFTPUtils.getClient(tftpSock) + " expected packet before time out, sending ACK/DATA again"));
                tftpSock.write(send);
                stuffedLink = true;
                try {
                    tftpSock.setSocketTimeOut(tftpSock.getSocketTimeOut() * 2);
                }
                catch (SocketException e) {
                    tftpLog.debug((Object)(TFTPUtils.getClient(tftpSock) + "Could not change timeout on socket. " + e.getMessage()));
                }
                continue;
            }
            if (tftpP instanceof ERROR) {
                throw new IOException(TFTPUtils.getClient(tftpSock) + " " + ((ERROR)tftpP).getErrorMessage());
            }
            if (tftpP instanceof ACK && TFTPUtils.correctAnswer(recv, (ACK)tftpP)) {
                try {
                    if (stuffedLink) {
                        stuffedLink = false;
                        tftpSock.setSocketTimeOut(timeout);
                    }
                }
                catch (SocketException e) {
                    tftpLog.debug((Object)(TFTPUtils.getClient(tftpSock) + "Could not change timeout on socket. " + e.getMessage()));
                }
                return (ACK)tftpP;
            }
            if (spamcount++ <= 5) continue;
            return null;
        }
        return null;
    }

    public static void sendErrPacket(TFTPSocket tftpSock, int errorCode, String errorMsg) {
        try {
            ERROR tftpP = new ERROR(errorCode, errorMsg);
            tftpSock.write(tftpP);
        }
        catch (Exception e) {
            tftpLog.debug((Object)(TFTPUtils.getClient(tftpSock) + " UDP send ERROR packet failure."));
            tftpLog.debug((Object)e.toString());
            return;
        }
        tftpLog.debug((Object)("SEND ERROR [" + TFTPUtils.getClient(tftpSock) + "] EC = [" + errorCode + "] " + errorMsg));
    }

    public static String getClient(TFTPSocket tftpSock) {
        String client = "";
        InetAddress addr = tftpSock.getAddress();
        int port = tftpSock.getPort();
        if (addr != null) {
            client = client + addr.getHostAddress();
        }
        if (port != 0) {
            client = client + ":";
            client = client + port;
        }
        return client;
    }

    public static boolean correctAnswer(ACK expecting, ACK received) {
        if (expecting == null) {
            return false;
        }
        if (received == null) {
            return false;
        }
        if (expecting.getOpCode() != received.getOpCode()) {
            return false;
        }
        return expecting.getBlockNr() == received.getBlockNr();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

