/*
 * Decompiled with CFR 0.152.
 */
package com.globalros.tftp.common;

import com.globalros.tftp.common.ACK;
import com.globalros.tftp.common.DATA;
import com.globalros.tftp.common.ERROR;
import com.globalros.tftp.common.OACK;
import com.globalros.tftp.common.RRQ;
import com.globalros.tftp.common.TFTPPacket;
import com.globalros.tftp.common.WRQ;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.log4j.Logger;

public class TFTPSocket {
    private int timeout;
    byte[] buffer;
    InetAddress destAddr;
    int destPort;
    static int handlePort;
    DatagramSocket udpSocket = TFTPSocket.getFreeSocket();
    static Logger tftpLog;
    public static final int BLOCK_SIZE = 512;
    static /* synthetic */ Class class$com$globalros$tftp$common$TFTPSocket;

    public TFTPSocket(int timeout) throws SocketException {
        this.setSocketTimeOut(timeout);
        this.buffer = new byte[528];
    }

    public void setSocketTimeOut(int secs) throws SocketException {
        this.timeout = secs * 1000;
        this.udpSocket.setSoTimeout(secs * 1000);
    }

    public void setSockTimeoutMSec(int msecs) throws SocketException {
        this.timeout = msecs;
        this.udpSocket.setSoTimeout(msecs);
    }

    public int getSocketTimeOut() {
        return this.timeout / 1000;
    }

    private static DatagramSocket getFreeSocket() throws SocketException {
        int loopPort = handlePort - 1;
        while (loopPort != handlePort) {
            if (handlePort < 29001 || ++handlePort > 65000) {
                handlePort = 29001;
            }
            try {
                DatagramSocket freeSocket = new DatagramSocket(handlePort);
                return freeSocket;
            }
            catch (SocketException e) {
            }
        }
        tftpLog.warn((Object)"Could not find a free port!");
        throw new SocketException();
    }

    public TFTPPacket read() throws IOException {
        DatagramPacket udpPacket = new DatagramPacket(this.buffer, 528);
        try {
            this.udpSocket.receive(udpPacket);
        }
        catch (InterruptedIOException e) {
            return null;
        }
        byte[] udpData = udpPacket.getData();
        int udpLength = udpPacket.getLength();
        tftpLog.debug((Object)("udpPacket.length in receive: " + udpLength));
        byte[] tftpPB = new byte[udpPacket.getLength()];
        System.arraycopy(udpData, udpPacket.getOffset(), tftpPB, 0, udpLength);
        TFTPPacket tftpP = null;
        try {
            int opcode = TFTPPacket.fetchOpCode(tftpPB);
            switch (opcode) {
                case 4: {
                    tftpP = new ACK(tftpPB);
                    break;
                }
                case 3: {
                    tftpP = new DATA(tftpPB, udpLength);
                    break;
                }
                case 1: {
                    tftpP = new RRQ(tftpPB);
                    break;
                }
                case 2: {
                    tftpP = new WRQ(tftpPB);
                    break;
                }
                case 6: {
                    tftpP = new OACK(tftpPB);
                    break;
                }
                case 5: {
                    tftpP = new ERROR(tftpPB);
                    break;
                }
                default: {
                    tftpLog.error((Object)("Unknown opcode: " + opcode));
                    break;
                }
            }
        }
        catch (InstantiationException e) {
            throw new IOException("Could not discover tftp packet in recieved data!" + e.getMessage());
        }
        tftpP.setPort(udpPacket.getPort());
        tftpP.setAddress(udpPacket.getAddress());
        return tftpP;
    }

    public void write(TFTPPacket tftpP) throws IOException {
        byte[] data = tftpP.getBytes();
        InetAddress address = tftpP.getAddress();
        int port = tftpP.getPort();
        if (this.udpSocket.isConnected()) {
            address = this.destAddr;
            port = this.destPort;
        }
        DatagramPacket udpPacket = new DatagramPacket(data, data.length, address, port);
        this.udpSocket.send(udpPacket);
    }

    public void connect(InetAddress addr, int port) {
        this.udpSocket.disconnect();
        this.udpSocket.connect(addr, port);
        this.destAddr = addr;
        this.destPort = port;
    }

    public void clear() {
        try {
            this.udpSocket.setSoTimeout(10);
        }
        catch (SocketException e1) {
            tftpLog.warn((Object)e1);
            e1.printStackTrace();
        }
        byte[] data = new byte[516];
        DatagramPacket udpPacket = new DatagramPacket(data, data.length);
        try {
            while (true) {
                this.udpSocket.receive(udpPacket);
            }
        }
        catch (SocketTimeoutException ste) {
            try {
                this.udpSocket.setSoTimeout(this.timeout);
            }
            catch (SocketException e1) {
                tftpLog.warn((Object)e1);
                e1.printStackTrace();
            }
            return;
        }
        catch (Exception e) {
            tftpLog.debug((Object)("[clear] :" + e.getMessage()));
            try {
                this.udpSocket.setSoTimeout(this.timeout);
            }
            catch (SocketException e1) {
                tftpLog.warn((Object)e1);
                e1.printStackTrace();
            }
            return;
        }
    }

    public void disconnect() {
        this.udpSocket.disconnect();
        this.udpSocket.close();
    }

    public int getPort() {
        return this.destPort;
    }

    public InetAddress getAddress() {
        return this.destAddr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tftpLog = Logger.getLogger((Class)(class$com$globalros$tftp$common$TFTPSocket == null ? (class$com$globalros$tftp$common$TFTPSocket = TFTPSocket.class$("com.globalros.tftp.common.TFTPSocket")) : class$com$globalros$tftp$common$TFTPSocket));
    }
}

