/*
 * Decompiled with CFR 0.152.
 */
package com.globalros.tftp.common;

import java.net.InetAddress;

public abstract class TFTPPacket {
    private InetAddress destAddr;
    private int destPort;
    static final int IX_OPCODE = 0;
    public static final int MIN_PACKET_SIZE = 4;
    public static final int OPCODE = 0;

    public TFTPPacket() {
    }

    public int readString(int index, byte[] b, StringBuffer sb) {
        int i;
        for (i = index; i < b.length && b[i] != 0; ++i) {
            sb.append((char)b[i]);
        }
        return ++i;
    }

    public TFTPPacket(byte[] tftpP) throws InstantiationException {
        if (tftpP == null || tftpP.length < this.getMinPacketSize()) {
            throw new InstantiationException("Argument passed to constructor is not a valid " + this.getClass().getName() + " packet!");
        }
        if (TFTPPacket.makeword(tftpP[0], tftpP[1]) != this.getOpCode()) {
            throw new InstantiationException("Argument passed to constructor is not a valid " + this.getClass().getName() + " packet!");
        }
    }

    public abstract byte[] getBytes();

    public int getMinPacketSize() {
        return 4;
    }

    public abstract int getOpCode();

    public static int fetchOpCode(byte[] tftpP) {
        if (tftpP == null) {
            return 0;
        }
        if (tftpP.length < 2) {
            return 0;
        }
        return TFTPPacket.makeword(tftpP[0], tftpP[1]);
    }

    public static int makeword(byte Hi, byte Lo) {
        return Hi << 8 & 0xFF00 | Lo & 0xFF;
    }

    public static byte getMsb(int i) {
        return (byte)(i >> 8 & 0xFF);
    }

    public static byte getLsb(int i) {
        return (byte)(i & 0xFF);
    }

    public void setAddress(InetAddress addr) {
        this.destAddr = addr;
    }

    public void setPort(int port) {
        this.destPort = port;
    }

    public InetAddress getAddress() {
        return this.destAddr;
    }

    public int getPort() {
        return this.destPort;
    }
}

