/*
 * Decompiled with CFR 0.152.
 */
package com.globalros.tftp.common;

import java.util.Hashtable;
import java.util.Map;

public class TFTPOptions
extends Hashtable {
    public static final String TSIZE = "tsize";
    public static final String TIMEOUT = "timeout";
    public static final String BLKSIZE = "blksize";

    public TFTPOptions(int initialCapacity) {
        super(initialCapacity);
    }

    public TFTPOptions() {
    }

    public TFTPOptions(Map t) {
        super(t);
    }

    public int getIntegerOption(String option) {
        String strValue = (String)this.get(option);
        if (strValue == null) {
            return -1;
        }
        try {
            Integer value = Integer.decode(strValue);
            return value;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setIntegerOption(String option, int value) {
        this.put(option, new Integer(value).toString());
    }

    public int getTimeout() {
        return this.getIntegerOption(TIMEOUT);
    }

    public void setTimeout(int to) {
        this.setIntegerOption(TIMEOUT, to);
    }

    public int getTransferSize() {
        return this.getIntegerOption(TSIZE);
    }

    public void setTransferSize(int tsize) {
        this.setIntegerOption(TSIZE, tsize);
    }

    public int getBlockSize() {
        return this.getIntegerOption(BLKSIZE);
    }

    public void setBlockSize(int blksize) {
        this.setIntegerOption(BLKSIZE, blksize);
    }

    public boolean hasOption(String name) {
        return this.containsKey(name);
    }

    public int getOptionsSize() {
        int size = 0;
        if (this.hasOption(TIMEOUT)) {
            size += TIMEOUT.length() + 1 + ("" + this.getTimeout()).length() + 1;
        }
        if (this.hasOption(TSIZE)) {
            size += TSIZE.length() + 1 + ("" + this.getTransferSize()).length() + 1;
        }
        return size;
    }

    public Object put(Object option, Object value) {
        if (!(option instanceof String)) {
            return null;
        }
        if (!(value instanceof String)) {
            return null;
        }
        ((String)option).toLowerCase();
        return super.put(option, value);
    }
}

