/*
 * Decompiled with CFR 0.152.
 */
package com.globalros.tftp.common;

import com.globalros.tftp.common.ACK;
import com.globalros.tftp.common.TFTPOptions;

public class OACK
extends ACK {
    private TFTPOptions options = null;
    public static final int OPCODE = 6;

    public OACK(int blockNr, TFTPOptions options) {
        super(blockNr);
        this.options = options;
    }

    public boolean hasTimeout() {
        if (this.options != null) {
            return this.options.hasOption("timeout");
        }
        return false;
    }

    public int getTimeout() {
        if (this.options != null) {
            return this.options.getTimeout();
        }
        return -1;
    }

    public boolean hasTransferSize() {
        if (this.options != null) {
            return this.options.hasOption("tsize");
        }
        return false;
    }

    public int getTransferSize() {
        if (this.options != null) {
            return this.options.getTransferSize();
        }
        return -1;
    }

    private int readOption(int IX_OPTION, byte[] b) throws InstantiationException {
        if (IX_OPTION >= b.length) {
            return IX_OPTION;
        }
        StringBuffer sb = new StringBuffer();
        int IX_VALUE = this.readString(IX_OPTION, b, sb);
        String option = sb.toString();
        sb = null;
        if (IX_VALUE >= b.length) {
            throw new InstantiationException("TFTP packet passed to constructor is not a complete " + this.getClass().getName() + " packet! Missing value for option: " + option);
        }
        sb = new StringBuffer();
        IX_OPTION = this.readString(IX_VALUE, b, sb);
        String value = sb.toString();
        sb = null;
        if (this.options == null) {
            this.options = new TFTPOptions(3);
        }
        this.options.put(option, value);
        return IX_OPTION;
    }

    public OACK(byte[] tftpP) throws InstantiationException {
        super(tftpP);
        int IX_OPTION = 2;
        while (IX_OPTION < tftpP.length - 2) {
            IX_OPTION = this.readOption(IX_OPTION, tftpP);
        }
        this.blockNr = 0;
    }

    private int getLength() {
        int tsize;
        int length = 4;
        if (this.options == null) {
            return length;
        }
        int timeout = this.options.getTimeout();
        if (timeout > 0) {
            length += "timeout".length() + ((String)this.options.get("timeout")).length() + 2;
        }
        if ((tsize = this.options.getTransferSize()) > 0) {
            length += "tsize".length() + ((String)this.options.get("tsize")).length() + 2;
        }
        return length;
    }

    public byte[] getBytes() {
        int tsize;
        byte[] tftpP = new byte[this.getLength()];
        tftpP[0] = 0;
        tftpP[1] = 6;
        int IX_OPTION = 2;
        int timeout = this.options.getTimeout();
        if (timeout > 0) {
            int length = "timeout".length();
            System.arraycopy("timeout".getBytes(), 0, tftpP, IX_OPTION, length);
            IX_OPTION += length;
            tftpP[IX_OPTION++] = 0;
            String timeoutValue = (String)this.options.get("timeout");
            length = timeoutValue.length();
            System.arraycopy(timeoutValue.getBytes(), 0, tftpP, IX_OPTION, length);
            IX_OPTION += length;
            tftpP[IX_OPTION++] = 0;
        }
        if ((tsize = this.options.getTransferSize()) > 0) {
            int length = "tsize".length();
            System.arraycopy("tsize".getBytes(), 0, tftpP, IX_OPTION, length);
            IX_OPTION += length;
            tftpP[IX_OPTION++] = 0;
            String tsizeValue = (String)this.options.get("tsize");
            length = tsizeValue.length();
            System.arraycopy(tsizeValue.getBytes(), 0, tftpP, IX_OPTION, length);
            IX_OPTION += length;
            tftpP[IX_OPTION++] = 0;
        }
        int IX_BLOCKNR = IX_OPTION;
        tftpP[IX_BLOCKNR] = (byte)(this.blockNr >> 8 & 0xFF);
        tftpP[IX_BLOCKNR + 1] = (byte)(this.blockNr & 0xFF);
        return tftpP;
    }

    public int getOpCode() {
        return 6;
    }
}

