/*
 * Decompiled with CFR 0.152.
 */
package com.globalros.tftp.common;

import com.globalros.tftp.common.TFTPOptions;
import com.globalros.tftp.common.TFTPPacket;
import org.apache.log4j.Logger;

public abstract class FRQ
extends TFTPPacket {
    private static Logger log = Logger.getLogger((String)"FRQ.class");
    TFTPOptions tftpOptions = null;
    private String fileName = "";
    private int mode = 0;
    private int tsize = 2048;
    static final int IX_FILENAME = 2;
    static final int UNKNOWN_MODE = 0;
    static final int ASCII_MODE = 1;
    public static final int OCTET_MODE = 2;
    static final int MAIL_MODE = 3;
    static final String[] modeStrings = new String[]{"unknown", "netascii", "octet", "mail"};

    private int readFileName(byte[] b) throws InstantiationException {
        if (2 >= b.length) {
            throw new InstantiationException("TFTP request passed to constructor is not a complete " + this.getClass().getName() + " packet! It does not contain the filename!");
        }
        StringBuffer sb = new StringBuffer();
        int IX_MODE = this.readString(2, b, sb);
        this.fileName = sb.toString();
        return IX_MODE;
    }

    private int readMode(int IX_MODE, byte[] b) throws InstantiationException {
        if (IX_MODE >= b.length) {
            throw new InstantiationException("TFTP packet passed to constructor is not a complete " + this.getClass().getName() + " packet! Mode could not be found");
        }
        StringBuffer sb = new StringBuffer();
        int IX_OPTION = this.readString(IX_MODE, b, sb);
        String modeString = sb.toString();
        for (int i = 1; i <= 3; ++i) {
            if (modeString.compareToIgnoreCase(FRQ.getModeString(i)) != 0) continue;
            this.mode = i;
            return IX_OPTION;
        }
        throw new InstantiationException("Unsupported mode found in the file request for mode: " + modeString);
    }

    private int readOption(int IX_OPTION, byte[] b) throws InstantiationException {
        if (IX_OPTION >= b.length) {
            return IX_OPTION;
        }
        StringBuffer sb = new StringBuffer();
        int IX_VALUE = this.readString(IX_OPTION, b, sb);
        String option = sb.toString();
        log.debug((Object)("name of option: " + option));
        if (IX_VALUE >= b.length) {
            throw new InstantiationException("TFTP packet passed to constructor is not a complete " + this.getClass().getName() + " packet! Missing value for option: " + option);
        }
        sb = new StringBuffer();
        IX_OPTION = this.readString(IX_VALUE, b, sb);
        String value = sb.toString();
        log.debug((Object)("value of option: " + value));
        if (this.tftpOptions == null) {
            this.tftpOptions = new TFTPOptions(3);
        }
        this.tftpOptions.put(option, value);
        return IX_OPTION;
    }

    public FRQ() {
    }

    public FRQ(byte[] tftpP) throws InstantiationException {
        super(tftpP);
        try {
            int IX_MODE = this.readFileName(tftpP);
            int IX_OPTION = this.readMode(IX_MODE, tftpP);
            if (IX_OPTION >= tftpP.length) {
                return;
            }
            while (IX_OPTION < tftpP.length) {
                IX_OPTION = this.readOption(IX_OPTION, tftpP);
            }
        }
        catch (Throwable t) {
            if (t instanceof InstantiationException) {
                throw (InstantiationException)t;
            }
            throw new InstantiationException("CODING ERROR? " + t.getMessage());
        }
    }

    public boolean hasOptions() {
        return this.tftpOptions != null;
    }

    public byte[] getBytes() {
        String modeString = "";
        if (this.mode >= 1 && this.mode <= 3) {
            modeString = modeStrings[this.mode];
        }
        int tftpLen = 2 + this.fileName.length() + 1 + modeString.length() + 1;
        if (this.hasOptions()) {
            tftpLen += this.tftpOptions.getOptionsSize();
        }
        byte[] tftpP = new byte[tftpLen];
        tftpP[0] = (byte)(this.getOpCode() >> 8 & 0xFF);
        tftpP[1] = (byte)(this.getOpCode() & 0xFF);
        System.arraycopy(this.fileName.getBytes(), 0, tftpP, 2, this.fileName.length());
        int IX_MODE = 2 + this.fileName.length();
        tftpP[IX_MODE++] = 0;
        System.arraycopy(modeString.getBytes(), 0, tftpP, IX_MODE, modeString.length());
        tftpP[IX_MODE += modeString.length()] = 0;
        int IX_OPTION = IX_MODE + 1;
        int optionLength = 0;
        String optionValue = null;
        if (this.hasOptions() && this.tftpOptions.hasOption("timeout")) {
            optionLength = "timeout".length();
            System.arraycopy("timeout".getBytes(), 0, tftpP, IX_OPTION, optionLength);
            IX_OPTION += optionLength;
            tftpP[IX_OPTION++] = 0;
            optionValue = "" + this.tftpOptions.getTimeout();
            optionLength = optionValue.length();
            System.arraycopy(optionValue.getBytes(), 0, tftpP, IX_OPTION, optionLength);
            IX_OPTION += optionLength;
            tftpP[IX_OPTION++] = 0;
        }
        if (this.hasOptions() && this.tftpOptions.hasOption("tsize")) {
            optionLength = "tsize".length();
            System.arraycopy("tsize".getBytes(), 0, tftpP, IX_OPTION, optionLength);
            IX_OPTION += optionLength;
            tftpP[IX_OPTION++] = 0;
            optionValue = "" + this.tftpOptions.getTransferSize();
            optionLength = optionValue.length();
            System.arraycopy(optionValue.getBytes(), 0, tftpP, IX_OPTION, optionLength);
            IX_OPTION += optionLength;
            tftpP[IX_OPTION++] = 0;
        }
        return tftpP;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public int getTimeout() {
        if (this.hasOptions()) {
            return this.tftpOptions.getTimeout();
        }
        return -1;
    }

    public void setTimeout(int timeout) {
        if (this.tftpOptions == null) {
            this.tftpOptions = new TFTPOptions();
        }
        this.tftpOptions.setTimeout(timeout);
    }

    public int getTransferSize() {
        if (this.hasOptions()) {
            return this.tftpOptions.getTransferSize();
        }
        return -1;
    }

    public void setTransferSize(int transferSize) {
        if (this.tftpOptions == null) {
            this.tftpOptions = new TFTPOptions();
        }
        this.tftpOptions.setTransferSize(transferSize);
    }

    static String getModeString(int mode) {
        if (mode > 0 && mode <= 3) {
            return modeStrings[mode];
        }
        return modeStrings[0];
    }
}

