/*
 * Decompiled with CFR 0.152.
 */
package com.globalros.tftp.common;

import com.globalros.tftp.common.TFTPPacket;

public class ERROR
extends TFTPPacket {
    private int errorCode = -1;
    private String errorMessage = "";
    public static final int ERR_NO_ERROR = -1;
    public static final int ERR_NOT_DEFINED = 0;
    public static final int ERR_FILE_NOT_FOUND = 1;
    public static final int ERR_ACCESS_VIOLATION = 2;
    public static final int ERR_DISK_FULL = 3;
    public static final int ERR_ILLEGAL_OP = 4;
    public static final int ERR_UNKNOWN_TRANS_ID = 5;
    public static final int ERR_FILE_EXISTS = 6;
    public static final int ERR_NO_SUCH_USER = 7;
    static final String[] errStrings = new String[]{"Unknown error", "File not found", "Access violation", "Disk full or allocation exceeded", "Illegal TFTP operation", "Unknown transfer ID", "File already exists", "No such user"};
    static final int IX_ERRCODE = 2;
    static final int IX_ERRMSG = 4;
    public static final int OPCODE = 5;
    public static final int MIN_PACKET_SIZE = 5;

    public ERROR(int code, String message) throws InstantiationException {
        this.errorCode = code;
        this.errorMessage = message;
    }

    public ERROR(byte[] tftpP) throws InstantiationException {
        super(tftpP);
        this.errorCode = ERROR.makeword(tftpP[2], tftpP[3]);
        if (4 >= tftpP.length) {
            throw new InstantiationException("Argument passed to constructor is not a complete " + this.getClass().getName() + " packet!");
        }
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 4; i < tftpP.length && tftpP[i] != 0; ++i) {
                sb.append((char)tftpP[i]);
            }
            this.errorMessage = sb.toString();
        }
        catch (Exception e) {
            throw new InstantiationException("CODING ERROR? " + e.toString());
        }
    }

    public byte[] getBytes() {
        int tftpLen = 5 + this.errorMessage.length() + 1;
        byte[] tftpP = new byte[tftpLen];
        tftpP[0] = 0;
        tftpP[1] = 5;
        tftpP[2] = (byte)(this.errorCode >> 8 & 0xFF);
        tftpP[3] = (byte)(this.errorCode & 0xFF);
        System.arraycopy(this.errorMessage.getBytes(), 0, tftpP, 4, this.errorMessage.length());
        tftpP[tftpLen - 1] = 0;
        return tftpP;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    static String getErrorMessage(int messageID) {
        if (messageID > 0 && messageID <= 7) {
            return errStrings[messageID];
        }
        return errStrings[0];
    }

    public int getOpCode() {
        return 5;
    }

    public int getMinPacketSize() {
        return 5;
    }
}

