/*
 * Decompiled with CFR 0.152.
 */
package com.globalros.tftp.common;

import com.globalros.tftp.common.ACK;

public class DATA
extends ACK {
    byte[] data = new byte[0];
    static final int IX_DATA = 4;
    public static final int OPCODE = 3;

    public DATA() throws InstantiationException {
    }

    public DATA(int blockNr, byte[] data) throws InstantiationException {
        this(blockNr, data, 0, data.length);
    }

    public DATA(int blockNr, byte[] data, int offset, int len) throws InstantiationException {
        super(blockNr);
        try {
            this.data = new byte[len];
            System.arraycopy(data, offset, this.data, 0, len);
        }
        catch (Exception e) {
            throw new InstantiationException("Data passed to constructor of DATA is invalid! " + e.toString());
        }
    }

    public DATA(byte[] tftpP, int tftpPLength) throws InstantiationException {
        super(tftpP);
        try {
            if (tftpPLength > tftpP.length) {
                tftpPLength = tftpP.length;
            }
            int len = tftpPLength - 4;
            this.data = new byte[len];
            System.arraycopy(tftpP, 4, this.data, 0, len);
        }
        catch (Exception e) {
            throw new InstantiationException("CODING ERROR? " + e.toString());
        }
    }

    public byte[] getBytes() {
        int tftpLen = 4;
        if (this.data != null) {
            tftpLen += this.data.length;
        }
        byte[] tftpP = new byte[tftpLen];
        tftpP[0] = 0;
        tftpP[1] = 3;
        tftpP[2] = (byte)(this.blockNr >> 8 & 0xFF);
        tftpP[3] = (byte)(this.blockNr & 0xFF);
        System.arraycopy(this.data, 0, tftpP, 4, this.data.length);
        return tftpP;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOpCode() {
        return 3;
    }
}

