/*
 * Decompiled with CFR 0.152.
 */
package com.globalros.tftp.client;

import com.globalros.tftp.common.ACK;
import com.globalros.tftp.common.DATA;
import com.globalros.tftp.common.ERROR;
import com.globalros.tftp.common.FRQ;
import com.globalros.tftp.common.OACK;
import com.globalros.tftp.common.RRQ;
import com.globalros.tftp.common.TFTPPacket;
import com.globalros.tftp.common.TFTPSocket;
import com.globalros.tftp.common.TFTPUtils;
import com.globalros.tftp.common.WRQ;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class TFTPClient {
    private static Logger log = Logger.getLogger((String)(class$com$globalros$tftp$client$TFTPClient == null ? (class$com$globalros$tftp$client$TFTPClient = TFTPClient.class$("com.globalros.tftp.client.TFTPClient")) : class$com$globalros$tftp$client$TFTPClient).getName());
    public static final int DEFAULT_PORT = 1069;
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_DOWNLOAD_FILENAME = "JUnitProperties.html";
    public static final String DEFAULT_CLIENT_UPLOAD_FILENAME = "client_upload.txt";
    public static final String DEFAULT_SERVER_UPLOAD_FILENAME = "server_upload.txt";
    private static final int MAX_PACKAGE_SIZE = 512;
    private String hostName = null;
    private int timeout;
    private int tsize;
    static /* synthetic */ Class class$com$globalros$tftp$client$TFTPClient;

    public TFTPClient(String hostName) {
        this.setHostName(hostName);
    }

    public static void main(String[] args) throws IOException, InstantiationException {
        String hostName = null;
        hostName = args.length != 1 ? DEFAULT_HOSTNAME : args[0];
        TFTPClient client = new TFTPClient(hostName);
        RRQ rrq = client.initialiseDownload();
        FileOutputStream readFos = new FileOutputStream(new File("/temp/hello.txt"));
        client.download(rrq, readFos);
        WRQ wrq = client.initialiseUpload();
        FileInputStream writeFis = new FileInputStream(new File("/temp/client_upload.txt"));
        client.upload(wrq, writeFis);
        log.debug((Object)"Client application has been run....");
    }

    public RRQ initialiseDownload() throws InstantiationException, UnknownHostException {
        return this.initialiseDownload(DEFAULT_DOWNLOAD_FILENAME, 0, 0);
    }

    public RRQ initialiseDownload(String fileName, int optionTimeout, int optionTransferSize) throws InstantiationException, UnknownHostException {
        RRQ rrq = new RRQ();
        rrq.setFileName(fileName);
        if (optionTimeout != 0) {
            rrq.setTimeout(optionTimeout);
        }
        if (optionTransferSize != 0) {
            rrq.setTransferSize(optionTransferSize);
        }
        rrq.setMode(2);
        rrq.setAddress(InetAddress.getByName(this.getHostName()));
        rrq.setPort(1069);
        return rrq;
    }

    public WRQ initialiseUpload() throws InstantiationException, UnknownHostException {
        return this.initialiseUpload(DEFAULT_SERVER_UPLOAD_FILENAME, 0, 0);
    }

    public WRQ initialiseUpload(String fileName, int optionTimeout, int optionTransferSize) throws InstantiationException, UnknownHostException {
        WRQ wrq = new WRQ();
        wrq.setFileName(fileName);
        if (optionTimeout != 0) {
            wrq.setTimeout(optionTimeout);
        }
        if (optionTransferSize != 0) {
            wrq.setTransferSize(optionTransferSize);
        }
        wrq.setMode(2);
        wrq.setAddress(InetAddress.getByName(this.getHostName()));
        wrq.setPort(1069);
        return wrq;
    }

    public boolean download(RRQ rrq, OutputStream os) throws SocketException, InstantiationException, IOException {
        TFTPSocket tftpSock = new TFTPSocket(5);
        int sequenceNumber = 1;
        byte[] dummyByteArray = new byte[1];
        DATA receive = new DATA(sequenceNumber, dummyByteArray);
        ACK surprisePacket = this.sendRequest(tftpSock, rrq, receive);
        if (surprisePacket == null) {
            log.debug((Object)"Nothing returned from the server after the initial read request.");
            return false;
        }
        if (surprisePacket instanceof OACK) {
            OACK oack = (OACK)surprisePacket;
            this.tsize = oack.getTransferSize();
            this.timeout = oack.getTimeout();
            ACK ack = new ACK(0);
            ack.setPort(surprisePacket.getPort());
            ack.setAddress(surprisePacket.getAddress());
            receive = (DATA)TFTPUtils.dataTransfer(tftpSock, ack, receive);
            if (receive == null) {
                log.debug((Object)"Nothing returned from the server after ack on oack.");
                return false;
            }
        } else if (surprisePacket instanceof DATA) {
            receive = (DATA)surprisePacket;
        }
        os.write(receive.getData());
        int serverPort = receive.getPort();
        log.debug((Object)("The server has chosen the following port as the communication port: " + serverPort));
        InetAddress serverAddress = rrq.getAddress();
        tftpSock.connect(serverAddress, serverPort);
        ACK ack = null;
        while (receive.getData().length >= 512) {
            ack = new ACK(sequenceNumber++);
            receive = new DATA(sequenceNumber, dummyByteArray);
            log.debug((Object)("receiving block" + sequenceNumber));
            receive = (DATA)TFTPUtils.dataTransfer(tftpSock, ack, receive);
            if (receive == null) {
                log.debug((Object)"Nothing returned from the server after the transfer.");
                return false;
            }
            os.write(receive.getData());
        }
        log.debug((Object)"send ack to say that we have received last message.");
        ack = new ACK(sequenceNumber);
        receive = (DATA)TFTPUtils.dataTransfer(tftpSock, ack, null);
        os.close();
        return true;
    }

    public boolean upload(WRQ wrq, InputStream is) throws SocketException, InstantiationException, IOException {
        log.debug((Object)("[M] : upload: " + wrq.getFileName()));
        TFTPSocket tftpSock = new TFTPSocket(5);
        int sequenceNumber = 0;
        ACK receive = new ACK(0);
        receive = this.sendRequest(tftpSock, wrq, receive);
        if (receive == null) {
            log.error((Object)"Nothing returned from the server after the initial send.");
            return false;
        }
        if (receive.getBlockNr() != 0) {
            log.error((Object)"The server has sent an ACK with wrong block number.");
            return false;
        }
        if (receive instanceof OACK) {
            OACK oack = (OACK)receive;
            this.tsize = oack.getTransferSize();
            this.timeout = oack.getTimeout();
        }
        int serverPort = receive.getPort();
        log.debug((Object)("The server has chosen the following port as the communication port: " + serverPort));
        InetAddress serverAddress = wrq.getAddress();
        tftpSock.connect(serverAddress, serverPort);
        byte[] sendBytes = new byte[512];
        DATA send = new DATA();
        int returnValue = 0;
        while ((returnValue = is.read(sendBytes)) != -1) {
            log.debug((Object)("sending packet number: " + sequenceNumber));
            send = new DATA(++sequenceNumber, sendBytes, 0, returnValue);
            receive = new ACK(sequenceNumber);
            receive = TFTPUtils.dataTransfer(tftpSock, send, receive);
        }
        is.close();
        return true;
    }

    public ACK sendRequest(TFTPSocket tftpSock, FRQ frq, ACK recv) {
        int retransmits = 0;
        int spamcount = 0;
        boolean stuffedLink = false;
        try {
            tftpSock.write(frq);
            if (stuffedLink) {
                tftpSock.setSocketTimeOut(tftpSock.getSocketTimeOut() * 2);
            }
        }
        catch (Exception e) {
            log.debug((Object)(TFTPUtils.getClient(tftpSock) + " UDP send packet failure1."));
            log.debug((Object)e.toString());
        }
        TFTPPacket tftpP = null;
        boolean receiving = true;
        while (receiving) {
            try {
                tftpP = tftpSock.read();
                if (stuffedLink) {
                    tftpSock.setSocketTimeOut(tftpSock.getSocketTimeOut());
                    stuffedLink = false;
                }
            }
            catch (IOException ios) {
                log.info((Object)("IOException: " + ios.getMessage()));
                return null;
            }
            if (tftpP == null) {
                if (retransmits++ > 5) {
                    TFTPUtils.sendErrPacket(tftpSock, 0, "Retransmit limit exceeded");
                    log.debug((Object)(TFTPUtils.getClient(tftpSock) + " Maximum retransmit count exceeded"));
                    return null;
                }
                log.debug((Object)(TFTPUtils.getClient(tftpSock) + " expected packet before time out, sending ACK/DATA again"));
                try {
                    tftpSock.write(frq);
                    stuffedLink = true;
                }
                catch (Exception e) {
                    log.debug((Object)(TFTPUtils.getClient(tftpSock) + " UDP send packet failure2."));
                    log.debug((Object)e.toString());
                }
                continue;
            }
            if (tftpP instanceof ERROR) {
                log.debug((Object)(TFTPUtils.getClient(tftpSock) + " " + ((ERROR)tftpP).getErrorMessage()));
                return null;
            }
            if (tftpP instanceof OACK && recv instanceof DATA && recv.getBlockNr() == 1) {
                return (ACK)tftpP;
            }
            if (tftpP instanceof OACK && recv instanceof ACK && recv.getBlockNr() == 0) {
                return (ACK)tftpP;
            }
            if (tftpP instanceof ACK && TFTPUtils.correctAnswer(recv, (ACK)tftpP)) {
                return (ACK)tftpP;
            }
            if (spamcount++ <= 5) continue;
            return null;
        }
        return null;
    }

    public int getOptionTimeout() {
        return this.timeout;
    }

    public int getOptionTransferSize() {
        return this.tsize;
    }

    private void setHostName(String hostName) {
        this.hostName = hostName;
    }

    private String getHostName() {
        return this.hostName;
    }

    private InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.getHostName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

