package tenqube.parser.util;

import android.util.Log;

import tenqube.parser.BuildConfig;

/**
 * Created by tenqube on 2017. 4. 10..
 */

public class LogUtil {

    private static final String LOG_PREFIX = "tenqube_";
    private static final int LOG_PREFIX_LENGTH = LOG_PREFIX.length();
    private static final int MAX_LOG_TAG_LENGTH = 23;

    public static String makeLogTag(String str) {
        if (str.length() > MAX_LOG_TAG_LENGTH - LOG_PREFIX_LENGTH) {
            return LOG_PREFIX + str.substring(0, MAX_LOG_TAG_LENGTH - LOG_PREFIX_LENGTH - 1);
        }

        return LOG_PREFIX + str;
    }

    public static String makeLogTag(Class cls) {
        return makeLogTag(cls.getSimpleName());
    }

    public static void LOGD(final String tag, String message) {
        //noinspection PointlessBooleanExpression,ConstantConditions
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.DEBUG)) {
            Log.d(tag, message);
        }
    }

    public static void LOGV(final String tag, String message) {
        //noinspection PointlessBooleanExpression,ConstantConditions
        if (BuildConfig.DEBUG && Log.isLoggable(tag, Log.VERBOSE)) {
            Log.v(tag, message);
        }
    }

    public static void LOGI(final String tag, String message) {
        if (BuildConfig.DEBUG ) {
            Log.i(tag, message);
        }
    }

    public static void LOGI(final String tag, String message, boolean isDebug) {
        if (isDebug) {
            Log.i(tag, message);
        }
    }

    public static void LOGE(final String tag, String message) {
        Log.e(tag, message);
    }


    public static void LOGW(final String tag, String message) {
        Log.w(tag, message);
    }


}
