package tenqube.parser.model;

/**
 * Created by tenqube on 2017. 3. 28..
 */

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import tenqube.parser.util.Validator;


public class SMS {


    public SMS(int smsId, String fullSms, String sender,String displaySender, String smsDate, int smsType) {
        this.smsId = smsId;
        this.fullSms = fullSms;
        this.sender = sender;
        this.displaySender = displaySender;
        this.smsDate = smsDate;
        this.smsType = smsType;
    }

    public boolean isValid () {
        return fullSms != null &&
                fullSms.length() < 300 &&
                sender != null &&
                smsDate != null &&
                Validator.isDate(smsDate);
    }



    /**
     * 문자 아이디
     */
    public int smsId;

    /**
     * 문자 메세지
     */
    public String fullSms;

    public String displaySender;
    /**
     * 전화번호
     */
    public String sender;

    /**
     * 수신 날짜 (YYYY-MM-dd HH:mm:ss)
     */
    public String smsDate;

    /**
     * 0:NOTIFICATION 1:MMS 2: SMS
     */
    public int smsType;

    public String title;

    @Override
    public String toString() {
        return "SMS{" +
                "fullSms='" + fullSms + '\'' +
                ", sender='" + sender + '\'' +
                ", smsDate='" + smsDate + '\'' +
                ", smsType=" + smsType +
                '}';
    }
}
