/*
 * Decompiled with CFR 0.152.
 */
package technology.zeroalpha.security.pgpwordlist;

import technology.zeroalpha.security.pgpwordlist.InvalidHexValueException;
import technology.zeroalpha.security.pgpwordlist.InvalidPGPWordException;
import technology.zeroalpha.security.pgpwordlist.PGPWordList;
import technology.zeroalpha.security.pgpwordlist.PGPWords;

public class PGPWordListConverter {
    private static final PGPWordList PGP_WORD_LIST = new PGPWordList();

    public String getEvenWordForHexValue(String hexString) throws InvalidHexValueException {
        int hexValue = this.convertHexStringToInteger(hexString);
        PGPWords pgpWords = PGP_WORD_LIST.getPGPWordsForHexValue(hexValue);
        return pgpWords.getEvenWord();
    }

    public String getOddWordForHexValue(String hexString) throws InvalidHexValueException {
        int hexValue = this.convertHexStringToInteger(hexString);
        PGPWords pgpWords = PGP_WORD_LIST.getPGPWordsForHexValue(hexValue);
        return pgpWords.getOddWord();
    }

    public String getHexValueForPGPWord(String pgpWord) throws InvalidPGPWordException {
        if (pgpWord == null) {
            throw new InvalidPGPWordException("Cannot convert null to hexadecimal value");
        }
        Integer hexValue = PGP_WORD_LIST.getHexValueByPGPWord(pgpWord);
        if (hexValue == null) {
            throw new InvalidPGPWordException(String.format("PGP Word not recognised: %s", pgpWord));
        }
        return Integer.toHexString(hexValue).toUpperCase();
    }

    private int convertHexStringToInteger(String hexString) throws InvalidHexValueException {
        if (hexString == null) {
            throw new InvalidHexValueException("Cannot convert to PGP Word - null passed in rather than hexadecimal value.");
        }
        String trimmedHexValue = hexString.trim();
        if (trimmedHexValue.isEmpty()) {
            throw new InvalidHexValueException("Cannot convert to PGP Word - empty string passed in rather than hexadecimal value.");
        }
        if (trimmedHexValue.length() > 2) {
            throw new InvalidHexValueException("Cannot convert to PGP Word - provided hexadecimal value is too large.");
        }
        try {
            return Integer.decode(String.format("0x%s", trimmedHexValue));
        }
        catch (NumberFormatException nfe) {
            throw new InvalidHexValueException("Cannot convert to PGP Word - provided string was not a valid hexadecimal value.", nfe);
        }
    }
}

