/*
 * Decompiled with CFR 0.152.
 */
package technology.zeroalpha.security.pgpwordlist;

import java.util.HashMap;
import java.util.Map;
import technology.zeroalpha.security.pgpwordlist.PGPWords;

public final class PGPWordList {
    private static final Map<Integer, PGPWords> PGP_WORDS_BY_HEX_VALUE = new HashMap<Integer, PGPWords>();
    private static final Map<String, Integer> HEX_VALUE_BY_PGP_WORD = new HashMap<String, Integer>();

    public PGPWordList() {
        this.addPGPWords(0, new PGPWords("aardvark", "adroitness"));
        this.addPGPWords(1, new PGPWords("absurd", "adviser"));
        this.addPGPWords(2, new PGPWords("accrue", "aftermath"));
        this.addPGPWords(3, new PGPWords("acme", "aggregate"));
        this.addPGPWords(4, new PGPWords("adrift", "alkali"));
        this.addPGPWords(5, new PGPWords("adult", "almighty"));
        this.addPGPWords(6, new PGPWords("afflict", "amulet"));
        this.addPGPWords(7, new PGPWords("ahead", "amusement"));
        this.addPGPWords(8, new PGPWords("aimless", "antenna"));
        this.addPGPWords(9, new PGPWords("Algol", "applicant"));
        this.addPGPWords(10, new PGPWords("allow", "Apollo"));
        this.addPGPWords(11, new PGPWords("alone", "armistice"));
        this.addPGPWords(12, new PGPWords("ammo", "article"));
        this.addPGPWords(13, new PGPWords("ancient", "asteroid"));
        this.addPGPWords(14, new PGPWords("apple", "Atlantic"));
        this.addPGPWords(15, new PGPWords("artist", "atmosphere"));
        this.addPGPWords(16, new PGPWords("assume", "autopsy"));
        this.addPGPWords(17, new PGPWords("Athens", "Babylon"));
        this.addPGPWords(18, new PGPWords("atlas", "backwater"));
        this.addPGPWords(19, new PGPWords("Aztec", "barbecue"));
        this.addPGPWords(20, new PGPWords("baboon", "belowground"));
        this.addPGPWords(21, new PGPWords("backfield", "bifocals"));
        this.addPGPWords(22, new PGPWords("backward", "bodyguard"));
        this.addPGPWords(23, new PGPWords("banjo", "bookseller"));
        this.addPGPWords(24, new PGPWords("beaming", "borderline"));
        this.addPGPWords(25, new PGPWords("bedlamp", "bottomless"));
        this.addPGPWords(26, new PGPWords("beehive", "Bradbury"));
        this.addPGPWords(27, new PGPWords("beeswax", "bravado"));
        this.addPGPWords(28, new PGPWords("befriend", "Brazilian"));
        this.addPGPWords(29, new PGPWords("Belfast", "breakaway"));
        this.addPGPWords(30, new PGPWords("berserk", "Burlington"));
        this.addPGPWords(31, new PGPWords("billiard", "businessman"));
        this.addPGPWords(32, new PGPWords("bison", "butterfat"));
        this.addPGPWords(33, new PGPWords("blackjack", "Camelot"));
        this.addPGPWords(34, new PGPWords("blockade", "candidate"));
        this.addPGPWords(35, new PGPWords("blowtorch", "cannonball"));
        this.addPGPWords(36, new PGPWords("bluebird", "Capricorn"));
        this.addPGPWords(37, new PGPWords("bombast", "caravan"));
        this.addPGPWords(38, new PGPWords("bookshelf", "caretaker"));
        this.addPGPWords(39, new PGPWords("brackish", "celebrate"));
        this.addPGPWords(40, new PGPWords("breadline", "cellulose"));
        this.addPGPWords(41, new PGPWords("breakup", "certify"));
        this.addPGPWords(42, new PGPWords("brickyard", "chambermaid"));
        this.addPGPWords(43, new PGPWords("briefcase", "Cherokee"));
        this.addPGPWords(44, new PGPWords("Burbank", "Chicago"));
        this.addPGPWords(45, new PGPWords("button", "clergyman"));
        this.addPGPWords(46, new PGPWords("buzzard", "coherence"));
        this.addPGPWords(47, new PGPWords("cement", "combustion"));
        this.addPGPWords(48, new PGPWords("chairlift", "commando"));
        this.addPGPWords(49, new PGPWords("chatter", "company"));
        this.addPGPWords(50, new PGPWords("checkup", "component"));
        this.addPGPWords(51, new PGPWords("chisel", "concurrent"));
        this.addPGPWords(52, new PGPWords("choking", "confidence"));
        this.addPGPWords(53, new PGPWords("chopper", "conformist"));
        this.addPGPWords(54, new PGPWords("Christmas", "congregate"));
        this.addPGPWords(55, new PGPWords("clamshell", "consensus"));
        this.addPGPWords(56, new PGPWords("classic", "consulting"));
        this.addPGPWords(57, new PGPWords("classroom", "corporate"));
        this.addPGPWords(58, new PGPWords("cleanup", "corrosion"));
        this.addPGPWords(59, new PGPWords("clockwork", "councilman"));
        this.addPGPWords(60, new PGPWords("cobra", "crossover"));
        this.addPGPWords(61, new PGPWords("commence", "crucifix"));
        this.addPGPWords(62, new PGPWords("concert", "cumbersome"));
        this.addPGPWords(63, new PGPWords("cowbell", "customer"));
        this.addPGPWords(64, new PGPWords("crackdown", "Dakota"));
        this.addPGPWords(65, new PGPWords("cranky", "decadence"));
        this.addPGPWords(66, new PGPWords("crowfoot", "December"));
        this.addPGPWords(67, new PGPWords("crucial", "decimal"));
        this.addPGPWords(68, new PGPWords("crumpled", "designing"));
        this.addPGPWords(69, new PGPWords("crusade", "detector"));
        this.addPGPWords(70, new PGPWords("cubic", "detergent"));
        this.addPGPWords(71, new PGPWords("dashboard", "determine"));
        this.addPGPWords(72, new PGPWords("deadbolt", "dictator"));
        this.addPGPWords(73, new PGPWords("deckhand", "dinosaur"));
        this.addPGPWords(74, new PGPWords("dogsled", "direction"));
        this.addPGPWords(75, new PGPWords("dragnet", "disable"));
        this.addPGPWords(76, new PGPWords("drainage", "disbelief"));
        this.addPGPWords(77, new PGPWords("dreadful", "disruptive"));
        this.addPGPWords(78, new PGPWords("drifter", "distortion"));
        this.addPGPWords(79, new PGPWords("dropper", "document"));
        this.addPGPWords(80, new PGPWords("drumbeat", "embezzle"));
        this.addPGPWords(81, new PGPWords("drunken", "enchanting"));
        this.addPGPWords(82, new PGPWords("Dupont", "enrollment"));
        this.addPGPWords(83, new PGPWords("dwelling", "enterprise"));
        this.addPGPWords(84, new PGPWords("eating", "equation"));
        this.addPGPWords(85, new PGPWords("edict", "equipment"));
        this.addPGPWords(86, new PGPWords("egghead", "escapade"));
        this.addPGPWords(87, new PGPWords("eightball", "Eskimo"));
        this.addPGPWords(88, new PGPWords("endorse", "everyday"));
        this.addPGPWords(89, new PGPWords("endow", "examine"));
        this.addPGPWords(90, new PGPWords("enlist", "existence"));
        this.addPGPWords(91, new PGPWords("erase", "exodus"));
        this.addPGPWords(92, new PGPWords("escape", "fascinate"));
        this.addPGPWords(93, new PGPWords("exceed", "filament"));
        this.addPGPWords(94, new PGPWords("eyeglass", "finicky"));
        this.addPGPWords(95, new PGPWords("eyetooth", "forever"));
        this.addPGPWords(96, new PGPWords("facial", "fortitude"));
        this.addPGPWords(97, new PGPWords("fallout", "frequency"));
        this.addPGPWords(98, new PGPWords("flagpole", "gadgetry"));
        this.addPGPWords(99, new PGPWords("flatfoot", "Galveston"));
        this.addPGPWords(100, new PGPWords("flytrap", "getaway"));
        this.addPGPWords(101, new PGPWords("fracture", "glossary"));
        this.addPGPWords(102, new PGPWords("framework", "gossamer"));
        this.addPGPWords(103, new PGPWords("freedom", "graduate"));
        this.addPGPWords(104, new PGPWords("frighten", "gravity"));
        this.addPGPWords(105, new PGPWords("gazelle", "guitarist"));
        this.addPGPWords(106, new PGPWords("Geiger", "hamburger"));
        this.addPGPWords(107, new PGPWords("glitter", "Hamilton"));
        this.addPGPWords(108, new PGPWords("glucose", "handiwork"));
        this.addPGPWords(109, new PGPWords("goggles", "hazardous"));
        this.addPGPWords(110, new PGPWords("goldfish", "headwaters"));
        this.addPGPWords(111, new PGPWords("gremlin", "hemisphere"));
        this.addPGPWords(112, new PGPWords("guidance", "hesitate"));
        this.addPGPWords(113, new PGPWords("hamlet", "hideaway"));
        this.addPGPWords(114, new PGPWords("highchair", "holiness"));
        this.addPGPWords(115, new PGPWords("hockey", "hurricane"));
        this.addPGPWords(116, new PGPWords("indoors", "hydraulic"));
        this.addPGPWords(117, new PGPWords("indulge", "impartial"));
        this.addPGPWords(118, new PGPWords("inverse", "impetus"));
        this.addPGPWords(119, new PGPWords("involve", "inception"));
        this.addPGPWords(120, new PGPWords("island", "indigo"));
        this.addPGPWords(121, new PGPWords("jawbone", "inertia"));
        this.addPGPWords(122, new PGPWords("keyboard", "infancy"));
        this.addPGPWords(123, new PGPWords("kickoff", "inferno"));
        this.addPGPWords(124, new PGPWords("kiwi", "informant"));
        this.addPGPWords(125, new PGPWords("klaxon", "insincere"));
        this.addPGPWords(126, new PGPWords("locale", "insurgent"));
        this.addPGPWords(127, new PGPWords("lockup", "integrate"));
        this.addPGPWords(128, new PGPWords("merit", "intention"));
        this.addPGPWords(129, new PGPWords("minnow", "inventive"));
        this.addPGPWords(130, new PGPWords("miser", "Istanbul"));
        this.addPGPWords(131, new PGPWords("Mohawk", "Jamaica"));
        this.addPGPWords(132, new PGPWords("mural", "Jupiter"));
        this.addPGPWords(133, new PGPWords("music", "leprosy"));
        this.addPGPWords(134, new PGPWords("necklace", "letterhead"));
        this.addPGPWords(135, new PGPWords("Neptune", "liberty"));
        this.addPGPWords(136, new PGPWords("newborn", "maritime"));
        this.addPGPWords(137, new PGPWords("nightbird", "matchmaker"));
        this.addPGPWords(138, new PGPWords("Oakland", "maverick"));
        this.addPGPWords(139, new PGPWords("obtuse", "Medusa"));
        this.addPGPWords(140, new PGPWords("offload", "megaton"));
        this.addPGPWords(141, new PGPWords("optic", "microscope"));
        this.addPGPWords(142, new PGPWords("orca", "microwave"));
        this.addPGPWords(143, new PGPWords("payday", "midsummer"));
        this.addPGPWords(144, new PGPWords("peachy", "millionaire"));
        this.addPGPWords(145, new PGPWords("pheasant", "miracle"));
        this.addPGPWords(146, new PGPWords("physique", "misnomer"));
        this.addPGPWords(147, new PGPWords("playhouse", "molasses"));
        this.addPGPWords(148, new PGPWords("Pluto", "molecule"));
        this.addPGPWords(149, new PGPWords("preclude", "Montana"));
        this.addPGPWords(150, new PGPWords("prefer", "monument"));
        this.addPGPWords(151, new PGPWords("preshrunk", "mosquito"));
        this.addPGPWords(152, new PGPWords("printer", "narrative"));
        this.addPGPWords(153, new PGPWords("prowler", "nebula"));
        this.addPGPWords(154, new PGPWords("pupil", "newsletter"));
        this.addPGPWords(155, new PGPWords("puppy", "Norwegian"));
        this.addPGPWords(156, new PGPWords("python", "October"));
        this.addPGPWords(157, new PGPWords("quadrant", "Ohio"));
        this.addPGPWords(158, new PGPWords("quiver", "onlooker"));
        this.addPGPWords(159, new PGPWords("quota", "opulent"));
        this.addPGPWords(160, new PGPWords("ragtime", "Orlando"));
        this.addPGPWords(161, new PGPWords("ratchet", "outfielder"));
        this.addPGPWords(162, new PGPWords("rebirth", "Pacific"));
        this.addPGPWords(163, new PGPWords("reform", "pandemic"));
        this.addPGPWords(164, new PGPWords("regain", "Pandora"));
        this.addPGPWords(165, new PGPWords("reindeer", "paperweight"));
        this.addPGPWords(166, new PGPWords("rematch", "paragon"));
        this.addPGPWords(167, new PGPWords("repay", "paragraph"));
        this.addPGPWords(168, new PGPWords("retouch", "paramount"));
        this.addPGPWords(169, new PGPWords("revenge", "passenger"));
        this.addPGPWords(170, new PGPWords("reward", "pedigree"));
        this.addPGPWords(171, new PGPWords("rhythm", "Pegasus"));
        this.addPGPWords(172, new PGPWords("ribcage", "penetrate"));
        this.addPGPWords(173, new PGPWords("ringbolt", "perceptive"));
        this.addPGPWords(174, new PGPWords("robust", "performance"));
        this.addPGPWords(175, new PGPWords("rocker", "pharmacy"));
        this.addPGPWords(176, new PGPWords("ruffled", "phonetic"));
        this.addPGPWords(177, new PGPWords("sailboat", "photograph"));
        this.addPGPWords(178, new PGPWords("sawdust", "pioneer"));
        this.addPGPWords(179, new PGPWords("scallion", "pocketful"));
        this.addPGPWords(180, new PGPWords("scenic", "politeness"));
        this.addPGPWords(181, new PGPWords("scorecard", "positive"));
        this.addPGPWords(182, new PGPWords("Scotland", "potato"));
        this.addPGPWords(183, new PGPWords("seabird", "processor"));
        this.addPGPWords(184, new PGPWords("select", "provincial"));
        this.addPGPWords(185, new PGPWords("sentence", "proximate"));
        this.addPGPWords(186, new PGPWords("shadow", "puberty"));
        this.addPGPWords(187, new PGPWords("shamrock", "publisher"));
        this.addPGPWords(188, new PGPWords("showgirl", "pyramid"));
        this.addPGPWords(189, new PGPWords("skullcap", "quantity"));
        this.addPGPWords(190, new PGPWords("skydive", "racketeer"));
        this.addPGPWords(191, new PGPWords("slingshot", "rebellion"));
        this.addPGPWords(192, new PGPWords("slowdown", "recipe"));
        this.addPGPWords(193, new PGPWords("snapline", "recover"));
        this.addPGPWords(194, new PGPWords("snapshot", "repellent"));
        this.addPGPWords(195, new PGPWords("snowcap", "replica"));
        this.addPGPWords(196, new PGPWords("snowslide", "reproduce"));
        this.addPGPWords(197, new PGPWords("solo", "resistor"));
        this.addPGPWords(198, new PGPWords("southward", "responsive"));
        this.addPGPWords(199, new PGPWords("soybean", "retraction"));
        this.addPGPWords(200, new PGPWords("spaniel", "retrieval"));
        this.addPGPWords(201, new PGPWords("spearhead", "retrospect"));
        this.addPGPWords(202, new PGPWords("spellbind", "revenue"));
        this.addPGPWords(203, new PGPWords("spheroid", "revival"));
        this.addPGPWords(204, new PGPWords("spigot", "revolver"));
        this.addPGPWords(205, new PGPWords("spindle", "sandalwood"));
        this.addPGPWords(206, new PGPWords("spyglass", "sardonic"));
        this.addPGPWords(207, new PGPWords("stagehand", "Saturday"));
        this.addPGPWords(208, new PGPWords("stagnate", "savagery"));
        this.addPGPWords(209, new PGPWords("stairway", "scavenger"));
        this.addPGPWords(210, new PGPWords("standard", "sensation"));
        this.addPGPWords(211, new PGPWords("stapler", "sociable"));
        this.addPGPWords(212, new PGPWords("steamship", "souvenir"));
        this.addPGPWords(213, new PGPWords("sterling", "specialist"));
        this.addPGPWords(214, new PGPWords("stockman", "speculate"));
        this.addPGPWords(215, new PGPWords("stopwatch", "stethoscope"));
        this.addPGPWords(216, new PGPWords("stormy", "stupendous"));
        this.addPGPWords(217, new PGPWords("sugar", "supportive"));
        this.addPGPWords(218, new PGPWords("surmount", "surrender"));
        this.addPGPWords(219, new PGPWords("suspense", "suspicious"));
        this.addPGPWords(220, new PGPWords("sweatband", "sympathy"));
        this.addPGPWords(221, new PGPWords("swelter", "tambourine"));
        this.addPGPWords(222, new PGPWords("tactics", "telephone"));
        this.addPGPWords(223, new PGPWords("talon", "therapist"));
        this.addPGPWords(224, new PGPWords("tapeworm", "tobacco"));
        this.addPGPWords(225, new PGPWords("tempest", "tolerance"));
        this.addPGPWords(226, new PGPWords("tiger", "tomorrow"));
        this.addPGPWords(227, new PGPWords("tissue", "torpedo"));
        this.addPGPWords(228, new PGPWords("tonic", "tradition"));
        this.addPGPWords(229, new PGPWords("topmost", "travesty"));
        this.addPGPWords(230, new PGPWords("tracker", "trombonist"));
        this.addPGPWords(231, new PGPWords("transit", "truncated"));
        this.addPGPWords(232, new PGPWords("trauma", "typewriter"));
        this.addPGPWords(233, new PGPWords("treadmill", "ultimate"));
        this.addPGPWords(234, new PGPWords("Trojan", "undaunted"));
        this.addPGPWords(235, new PGPWords("trouble", "underfoot"));
        this.addPGPWords(236, new PGPWords("tumor", "unicorn"));
        this.addPGPWords(237, new PGPWords("tunnel", "unify"));
        this.addPGPWords(238, new PGPWords("tycoon", "universe"));
        this.addPGPWords(239, new PGPWords("uncut", "unravel"));
        this.addPGPWords(240, new PGPWords("unearth", "upcoming"));
        this.addPGPWords(241, new PGPWords("unwind", "vacancy"));
        this.addPGPWords(242, new PGPWords("uproot", "vagabond"));
        this.addPGPWords(243, new PGPWords("upset", "vertigo"));
        this.addPGPWords(244, new PGPWords("upshot", "Virginia"));
        this.addPGPWords(245, new PGPWords("vapor", "visitor"));
        this.addPGPWords(246, new PGPWords("village", "vocalist"));
        this.addPGPWords(247, new PGPWords("virus", "voyager"));
        this.addPGPWords(248, new PGPWords("Vulcan", "warranty"));
        this.addPGPWords(249, new PGPWords("waffle", "Waterloo"));
        this.addPGPWords(250, new PGPWords("wallet", "whimsical"));
        this.addPGPWords(251, new PGPWords("watchword", "Wichita"));
        this.addPGPWords(252, new PGPWords("wayside", "Wilmington"));
        this.addPGPWords(253, new PGPWords("willow", "Wyoming"));
        this.addPGPWords(254, new PGPWords("woodlark", "yesteryear"));
        this.addPGPWords(255, new PGPWords("Zulu", "Yucatan"));
    }

    private void addPGPWords(int hexValue, PGPWords pgpWords) {
        PGP_WORDS_BY_HEX_VALUE.put(hexValue, pgpWords);
        HEX_VALUE_BY_PGP_WORD.put(pgpWords.getEvenWord().toLowerCase(), hexValue);
        HEX_VALUE_BY_PGP_WORD.put(pgpWords.getOddWord().toLowerCase(), hexValue);
    }

    public Integer getHexValueByPGPWord(String pgpWord) {
        if (pgpWord == null) {
            return null;
        }
        return HEX_VALUE_BY_PGP_WORD.get(pgpWord.toLowerCase());
    }

    public PGPWords getPGPWordsForHexValue(int hexValue) {
        return PGP_WORDS_BY_HEX_VALUE.get(hexValue);
    }
}

