// Generated by delombok at Mon Mar 13 12:01:10 UTC 2023
package technology.semi.weaviate.client.v1.graphql.query.builder;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.filters.WhereFilter;
import technology.semi.weaviate.client.v1.filters.WhereFilterUtil;
import technology.semi.weaviate.client.v1.graphql.query.argument.AskArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.Bm25Argument;
import technology.semi.weaviate.client.v1.graphql.query.argument.HybridArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.GroupArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.SortArguments;
import technology.semi.weaviate.client.v1.graphql.query.fields.Field;
import technology.semi.weaviate.client.v1.graphql.query.fields.Fields;
import technology.semi.weaviate.client.v1.graphql.query.fields.GenerativeSearchBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GetBuilder implements Query {
  private final String className;
  private final Fields fields;
  private final Integer offset;
  private final Integer limit;
  private final String after;
  private final WhereFilter withWhereFilter;
  private final NearTextArgument withNearTextFilter;
  private final Bm25Argument withBm25Filter;
  private final HybridArgument withHybridFilter;
  private final NearObjectArgument withNearObjectFilter;
  private final AskArgument withAskArgument;
  private final NearImageArgument withNearImageFilter;
  private final NearVectorArgument withNearVectorFilter;
  private final GroupArgument withGroupArgument;
  private final SortArguments withSortArguments;
  private final GenerativeSearchBuilder withGenerativeSearch;

  private boolean includesFilterClause() {
    return ObjectUtils.anyNotNull(withWhereFilter, withNearTextFilter, withNearObjectFilter, withNearVectorFilter, withNearImageFilter, withGroupArgument, withAskArgument, withBm25Filter, withHybridFilter, limit, offset, withSortArguments);
  }

  private String createFilterClause() {
    if (includesFilterClause()) {
      Set<String> filters = new LinkedHashSet<>();
      if (withWhereFilter != null) {
        filters.add(WhereFilterUtil.toGraphQLString(withWhereFilter));
      }
      if (withNearTextFilter != null) {
        filters.add(withNearTextFilter.build());
      }
      if (withBm25Filter != null) {
        filters.add(withBm25Filter.build());
      }
      if (withHybridFilter != null) {
        filters.add(withHybridFilter.build());
      }
      if (withNearObjectFilter != null) {
        filters.add(withNearObjectFilter.build());
      }
      if (withNearVectorFilter != null) {
        filters.add(withNearVectorFilter.build());
      }
      if (withGroupArgument != null) {
        filters.add(withGroupArgument.build());
      }
      if (withAskArgument != null) {
        filters.add(withAskArgument.build());
      }
      if (withNearImageFilter != null) {
        filters.add(withNearImageFilter.build());
      }
      if (limit != null) {
        filters.add(String.format("limit: %s", limit));
      }
      if (offset != null) {
        filters.add(String.format("offset: %s", offset));
      }
      if (after != null) {
        filters.add(String.format("after: \"%s\"", after));
      }
      if (withSortArguments != null) {
        filters.add(withSortArguments.build());
      }
      return String.format("(%s)", StringUtils.joinWith(", ", filters.toArray()));
    }
    return "";
  }

  private String createFields() {
    if (ObjectUtils.allNull(fields, withGenerativeSearch)) {
      return "";
    }
    if (withGenerativeSearch == null) {
      return fields.build();
    }
    Field generate = withGenerativeSearch.build();
    Field generateAdditional = Field.builder().name("_additional").fields(new Field[] {generate}).build();
    if (fields == null) {
      return generateAdditional.build();
    }
    // check if _additional field exists. If missing just add new _additional with generate,
    // if exists merge generate into present one
    Map<Boolean, List<Field>> grouped = Arrays.stream(fields.getFields()).collect(Collectors.groupingBy(f -> "_additional".equals(f.getName())));
    List<Field> additionals = grouped.getOrDefault(true, new ArrayList<>());
    if (additionals.isEmpty()) {
      additionals.add(generateAdditional);
    } else {
      Field[] mergedInternalFields = Stream.concat(Arrays.stream(additionals.get(0).getFields()), Stream.of(generate)).toArray(Field[]::new);
      additionals.set(0, Field.builder().name("_additional").fields(mergedInternalFields).build());
    }
    Field[] allFields = Stream.concat(grouped.getOrDefault(false, new ArrayList<>()).stream(), additionals.stream()).toArray(Field[]::new);
    return Fields.builder().fields(allFields).build().build();
  }

  @Override
  public String buildQuery() {
    return String.format("{Get{%s%s{%s}}}", className, createFilterClause(), createFields());
  }

  @java.lang.SuppressWarnings("all")
  GetBuilder(final String className, final Fields fields, final Integer offset, final Integer limit, final String after, final WhereFilter withWhereFilter, final NearTextArgument withNearTextFilter, final Bm25Argument withBm25Filter, final HybridArgument withHybridFilter, final NearObjectArgument withNearObjectFilter, final AskArgument withAskArgument, final NearImageArgument withNearImageFilter, final NearVectorArgument withNearVectorFilter, final GroupArgument withGroupArgument, final SortArguments withSortArguments, final GenerativeSearchBuilder withGenerativeSearch) {
    this.className = className;
    this.fields = fields;
    this.offset = offset;
    this.limit = limit;
    this.after = after;
    this.withWhereFilter = withWhereFilter;
    this.withNearTextFilter = withNearTextFilter;
    this.withBm25Filter = withBm25Filter;
    this.withHybridFilter = withHybridFilter;
    this.withNearObjectFilter = withNearObjectFilter;
    this.withAskArgument = withAskArgument;
    this.withNearImageFilter = withNearImageFilter;
    this.withNearVectorFilter = withNearVectorFilter;
    this.withGroupArgument = withGroupArgument;
    this.withSortArguments = withSortArguments;
    this.withGenerativeSearch = withGenerativeSearch;
  }


  @java.lang.SuppressWarnings("all")
  public static class GetBuilderBuilder {
    @java.lang.SuppressWarnings("all")
    private String className;
    @java.lang.SuppressWarnings("all")
    private Fields fields;
    @java.lang.SuppressWarnings("all")
    private Integer offset;
    @java.lang.SuppressWarnings("all")
    private Integer limit;
    @java.lang.SuppressWarnings("all")
    private String after;
    @java.lang.SuppressWarnings("all")
    private WhereFilter withWhereFilter;
    @java.lang.SuppressWarnings("all")
    private NearTextArgument withNearTextFilter;
    @java.lang.SuppressWarnings("all")
    private Bm25Argument withBm25Filter;
    @java.lang.SuppressWarnings("all")
    private HybridArgument withHybridFilter;
    @java.lang.SuppressWarnings("all")
    private NearObjectArgument withNearObjectFilter;
    @java.lang.SuppressWarnings("all")
    private AskArgument withAskArgument;
    @java.lang.SuppressWarnings("all")
    private NearImageArgument withNearImageFilter;
    @java.lang.SuppressWarnings("all")
    private NearVectorArgument withNearVectorFilter;
    @java.lang.SuppressWarnings("all")
    private GroupArgument withGroupArgument;
    @java.lang.SuppressWarnings("all")
    private SortArguments withSortArguments;
    @java.lang.SuppressWarnings("all")
    private GenerativeSearchBuilder withGenerativeSearch;

    @java.lang.SuppressWarnings("all")
    GetBuilderBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder className(final String className) {
      this.className = className;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder fields(final Fields fields) {
      this.fields = fields;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder offset(final Integer offset) {
      this.offset = offset;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder limit(final Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder after(final String after) {
      this.after = after;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withWhereFilter(final WhereFilter withWhereFilter) {
      this.withWhereFilter = withWhereFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearTextFilter(final NearTextArgument withNearTextFilter) {
      this.withNearTextFilter = withNearTextFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withBm25Filter(final Bm25Argument withBm25Filter) {
      this.withBm25Filter = withBm25Filter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withHybridFilter(final HybridArgument withHybridFilter) {
      this.withHybridFilter = withHybridFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearObjectFilter(final NearObjectArgument withNearObjectFilter) {
      this.withNearObjectFilter = withNearObjectFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withAskArgument(final AskArgument withAskArgument) {
      this.withAskArgument = withAskArgument;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearImageFilter(final NearImageArgument withNearImageFilter) {
      this.withNearImageFilter = withNearImageFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withNearVectorFilter(final NearVectorArgument withNearVectorFilter) {
      this.withNearVectorFilter = withNearVectorFilter;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withGroupArgument(final GroupArgument withGroupArgument) {
      this.withGroupArgument = withGroupArgument;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withSortArguments(final SortArguments withSortArguments) {
      this.withSortArguments = withSortArguments;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public GetBuilder.GetBuilderBuilder withGenerativeSearch(final GenerativeSearchBuilder withGenerativeSearch) {
      this.withGenerativeSearch = withGenerativeSearch;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public GetBuilder build() {
      return new GetBuilder(this.className, this.fields, this.offset, this.limit, this.after, this.withWhereFilter, this.withNearTextFilter, this.withBm25Filter, this.withHybridFilter, this.withNearObjectFilter, this.withAskArgument, this.withNearImageFilter, this.withNearVectorFilter, this.withGroupArgument, this.withSortArguments, this.withGenerativeSearch);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "GetBuilder.GetBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", offset=" + this.offset + ", limit=" + this.limit + ", after=" + this.after + ", withWhereFilter=" + this.withWhereFilter + ", withNearTextFilter=" + this.withNearTextFilter + ", withBm25Filter=" + this.withBm25Filter + ", withHybridFilter=" + this.withHybridFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withGroupArgument=" + this.withGroupArgument + ", withSortArguments=" + this.withSortArguments + ", withGenerativeSearch=" + this.withGenerativeSearch + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static GetBuilder.GetBuilderBuilder builder() {
    return new GetBuilder.GetBuilderBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getClassName() {
    return this.className;
  }

  @java.lang.SuppressWarnings("all")
  public Fields getFields() {
    return this.fields;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getOffset() {
    return this.offset;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getLimit() {
    return this.limit;
  }

  @java.lang.SuppressWarnings("all")
  public String getAfter() {
    return this.after;
  }

  @java.lang.SuppressWarnings("all")
  public WhereFilter getWithWhereFilter() {
    return this.withWhereFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextArgument getWithNearTextFilter() {
    return this.withNearTextFilter;
  }

  @java.lang.SuppressWarnings("all")
  public Bm25Argument getWithBm25Filter() {
    return this.withBm25Filter;
  }

  @java.lang.SuppressWarnings("all")
  public HybridArgument getWithHybridFilter() {
    return this.withHybridFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearObjectArgument getWithNearObjectFilter() {
    return this.withNearObjectFilter;
  }

  @java.lang.SuppressWarnings("all")
  public AskArgument getWithAskArgument() {
    return this.withAskArgument;
  }

  @java.lang.SuppressWarnings("all")
  public NearImageArgument getWithNearImageFilter() {
    return this.withNearImageFilter;
  }

  @java.lang.SuppressWarnings("all")
  public NearVectorArgument getWithNearVectorFilter() {
    return this.withNearVectorFilter;
  }

  @java.lang.SuppressWarnings("all")
  public GroupArgument getWithGroupArgument() {
    return this.withGroupArgument;
  }

  @java.lang.SuppressWarnings("all")
  public SortArguments getWithSortArguments() {
    return this.withSortArguments;
  }

  @java.lang.SuppressWarnings("all")
  public GenerativeSearchBuilder getWithGenerativeSearch() {
    return this.withGenerativeSearch;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "GetBuilder(className=" + this.getClassName() + ", fields=" + this.getFields() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", after=" + this.getAfter() + ", withWhereFilter=" + this.getWithWhereFilter() + ", withNearTextFilter=" + this.getWithNearTextFilter() + ", withBm25Filter=" + this.getWithBm25Filter() + ", withHybridFilter=" + this.getWithHybridFilter() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ", withGroupArgument=" + this.getWithGroupArgument() + ", withSortArguments=" + this.getWithSortArguments() + ", withGenerativeSearch=" + this.getWithGenerativeSearch() + ")";
  }
}
