// Generated by delombok at Mon Mar 13 12:01:10 UTC 2023
package technology.semi.weaviate.client.v1.batch.util;

import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.base.util.DbVersionSupport;
import technology.semi.weaviate.client.base.util.TriConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ReferencesPath {
  public String buildCreate(Params params) {
    return build(params, this::addQueryConsistencyLevel);
  }

  @SafeVarargs
  private final String build(Params params, TriConsumer<Params, List<String>, List<String>>... appenders) {
    Objects.requireNonNull(params);
    List<String> pathParams = new ArrayList<>();
    List<String> queryParams = new ArrayList<>();
    pathParams.add("/batch/references");
    Arrays.stream(appenders).forEach(consumer -> consumer.accept(params, pathParams, queryParams));
    String path = String.join("/", pathParams);
    if (!queryParams.isEmpty()) {
      return path + "?" + String.join("&", queryParams);
    }
    return path;
  }

  private void addQueryConsistencyLevel(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.consistencyLevel)) {
      queryParams.add(String.format("%s=%s", "consistency_level", StringUtils.trim(params.consistencyLevel)));
    }
  }


  public static class Params {
    private final String consistencyLevel;

    @java.lang.SuppressWarnings("all")
    Params(final String consistencyLevel) {
      this.consistencyLevel = consistencyLevel;
    }


    @java.lang.SuppressWarnings("all")
    public static class ParamsBuilder {
      @java.lang.SuppressWarnings("all")
      private String consistencyLevel;

      @java.lang.SuppressWarnings("all")
      ParamsBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public ReferencesPath.Params.ParamsBuilder consistencyLevel(final String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public ReferencesPath.Params build() {
        return new ReferencesPath.Params(this.consistencyLevel);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      public java.lang.String toString() {
        return "ReferencesPath.Params.ParamsBuilder(consistencyLevel=" + this.consistencyLevel + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    public static ReferencesPath.Params.ParamsBuilder builder() {
      return new ReferencesPath.Params.ParamsBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "ReferencesPath.Params(consistencyLevel=" + this.consistencyLevel + ")";
    }
  }
}
