// Generated by delombok at Thu Feb 23 13:54:59 UTC 2023
package technology.semi.weaviate.client.v1.graphql.query.argument;

import org.apache.commons.lang3.StringUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.Set;

public class NearImageArgument implements Argument {
  private final String image;
  private final File imageFile;
  private final Float certainty;
  private final Float distance;

  private String readFile(File file) {
    try {
      byte[] content = Files.readAllBytes(Paths.get(file.toURI()));
      return Base64.getEncoder().encodeToString(content);
    } catch (Exception e) {
      return null;
    }
  }

  private String getContent() {
    if (StringUtils.isNotBlank(image)) {
      if (image.startsWith("data:")) {
        String base64 = ";base64,";
        return image.substring(image.indexOf(base64) + base64.length());
      }
      return image;
    }
    if (imageFile != null) {
      return readFile(imageFile);
    }
    return null;
  }

  @Override
  public String build() {
    Set<String> fields = new LinkedHashSet<>();
    String content = getContent();
    if (StringUtils.isNotBlank(content)) {
      fields.add(String.format("image: \"%s\"", content));
    }
    if (certainty != null) {
      fields.add(String.format("certainty: %s", certainty));
    }
    if (distance != null) {
      fields.add(String.format("distance: %s", distance));
    }
    return String.format("nearImage: {%s}", StringUtils.joinWith(" ", fields.toArray()));
  }

  @java.lang.SuppressWarnings("all")
  NearImageArgument(final String image, final File imageFile, final Float certainty, final Float distance) {
    this.image = image;
    this.imageFile = imageFile;
    this.certainty = certainty;
    this.distance = distance;
  }


  @java.lang.SuppressWarnings("all")
  public static class NearImageArgumentBuilder {
    @java.lang.SuppressWarnings("all")
    private String image;
    @java.lang.SuppressWarnings("all")
    private File imageFile;
    @java.lang.SuppressWarnings("all")
    private Float certainty;
    @java.lang.SuppressWarnings("all")
    private Float distance;

    @java.lang.SuppressWarnings("all")
    NearImageArgumentBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearImageArgument.NearImageArgumentBuilder image(final String image) {
      this.image = image;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearImageArgument.NearImageArgumentBuilder imageFile(final File imageFile) {
      this.imageFile = imageFile;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearImageArgument.NearImageArgumentBuilder certainty(final Float certainty) {
      this.certainty = certainty;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearImageArgument.NearImageArgumentBuilder distance(final Float distance) {
      this.distance = distance;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public NearImageArgument build() {
      return new NearImageArgument(this.image, this.imageFile, this.certainty, this.distance);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "NearImageArgument.NearImageArgumentBuilder(image=" + this.image + ", imageFile=" + this.imageFile + ", certainty=" + this.certainty + ", distance=" + this.distance + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static NearImageArgument.NearImageArgumentBuilder builder() {
    return new NearImageArgument.NearImageArgumentBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getImage() {
    return this.image;
  }

  @java.lang.SuppressWarnings("all")
  public File getImageFile() {
    return this.imageFile;
  }

  @java.lang.SuppressWarnings("all")
  public Float getCertainty() {
    return this.certainty;
  }

  @java.lang.SuppressWarnings("all")
  public Float getDistance() {
    return this.distance;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "NearImageArgument(image=" + this.getImage() + ", imageFile=" + this.getImageFile() + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ")";
  }
}
