// Generated by delombok at Thu Jul 07 18:06:48 UTC 2022
package technology.semi.weaviate.client.base.util;

import org.apache.commons.lang3.StringUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;

public class BeaconPath {
  private final DbVersionSupport support;

  public BeaconPath(DbVersionSupport support) {
    this.support = support;
  }

  public String buildBatchFrom(Params pathParams) {
    return build(pathParams, this::addClassName, this::addId, this::addProperty);
  }

  public String buildBatchTo(Params pathParams) {
    return build(pathParams, this::addClassNameDeprecatedNotSupportedCheck, this::addId);
  }

  public String buildSingle(Params pathParams) {
    return build(pathParams, this::addClassNameDeprecatedNotSupportedCheck, this::addId);
  }

  @SafeVarargs
  private final String build(Params pathParams, BiConsumer<StringBuilder, Params>... modifiers) {
    Objects.requireNonNull(pathParams);
    StringBuilder path = new StringBuilder("weaviate://localhost");
    Arrays.stream(modifiers).forEach(consumer -> consumer.accept(path, pathParams));
    return path.toString();
  }

  private void addClassNameDeprecatedNotSupportedCheck(StringBuilder path, Params pathParams) {
    if (support.supportsClassNameNamespacedEndpoints()) {
      if (StringUtils.isNotBlank(pathParams.className)) {
        path.append("/").append(StringUtils.trim(pathParams.className));
      } else {
        support.warnDeprecatedNonClassNameNamespacedEndpointsForBeacons();
      }
    } else if (StringUtils.isNotBlank(pathParams.className)) {
      support.warnNotSupportedClassNamespacedEndpointsForBeacons();
    }
  }

  private void addClassName(StringBuilder path, Params pathParams) {
    if (StringUtils.isNotBlank(pathParams.className)) {
      path.append("/").append(StringUtils.trim(pathParams.className));
    }
  }

  private void addId(StringBuilder path, Params pathParams) {
    if (StringUtils.isNotBlank(pathParams.id)) {
      path.append("/").append(StringUtils.trim(pathParams.id));
    }
  }

  private void addProperty(StringBuilder path, Params pathParams) {
    if (StringUtils.isNotBlank(pathParams.property)) {
      path.append("/").append(StringUtils.trim(pathParams.property));
    }
  }


  public static class Params {
    private final String id;
    private final String className;
    private final String property;

    @java.lang.SuppressWarnings("all")
    Params(final String id, final String className, final String property) {
      this.id = id;
      this.className = className;
      this.property = property;
    }


    @java.lang.SuppressWarnings("all")
    public static class ParamsBuilder {
      @java.lang.SuppressWarnings("all")
      private String id;
      @java.lang.SuppressWarnings("all")
      private String className;
      @java.lang.SuppressWarnings("all")
      private String property;

      @java.lang.SuppressWarnings("all")
      ParamsBuilder() {
      }

      @java.lang.SuppressWarnings("all")
      public BeaconPath.Params.ParamsBuilder id(final String id) {
        this.id = id;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public BeaconPath.Params.ParamsBuilder className(final String className) {
        this.className = className;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public BeaconPath.Params.ParamsBuilder property(final String property) {
        this.property = property;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public BeaconPath.Params build() {
        return new BeaconPath.Params(this.id, this.className, this.property);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      public java.lang.String toString() {
        return "BeaconPath.Params.ParamsBuilder(id=" + this.id + ", className=" + this.className + ", property=" + this.property + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    public static BeaconPath.Params.ParamsBuilder builder() {
      return new BeaconPath.Params.ParamsBuilder();
    }
  }
}
