/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.builder;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.filters.WhereFilter;
import technology.semi.weaviate.client.v1.filters.WhereFilterUtil;
import technology.semi.weaviate.client.v1.graphql.query.argument.AskArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import technology.semi.weaviate.client.v1.graphql.query.builder.Query;
import technology.semi.weaviate.client.v1.graphql.query.fields.Fields;

public class AggregateBuilder
implements Query {
    private final String className;
    private final Fields fields;
    private final String groupByClausePropertyName;
    private final WhereFilter withWhereFilter;
    private final NearTextArgument withNearTextFilter;
    private final NearObjectArgument withNearObjectFilter;
    private final NearVectorArgument withNearVectorFilter;
    private final AskArgument withAskArgument;
    private final NearImageArgument withNearImageFilter;
    private final Integer objectLimit;
    private final Integer limit;

    private boolean includesFilterClause() {
        return ObjectUtils.anyNotNull((Object[])new Object[]{this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.objectLimit, this.withAskArgument, this.withNearImageFilter, this.limit}) || StringUtils.isNotBlank((CharSequence)this.groupByClausePropertyName);
    }

    private String createFilterClause() {
        if (this.includesFilterClause()) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)this.groupByClausePropertyName)) {
                filters.add(String.format("groupBy: \"%s\"", this.groupByClausePropertyName));
            }
            if (this.withWhereFilter != null) {
                filters.add(WhereFilterUtil.toGraphQLString(this.withWhereFilter));
            }
            if (this.withNearTextFilter != null) {
                filters.add(this.withNearTextFilter.build());
            }
            if (this.withNearObjectFilter != null) {
                filters.add(this.withNearObjectFilter.build());
            }
            if (this.withNearVectorFilter != null) {
                filters.add(this.withNearVectorFilter.build());
            }
            if (this.withAskArgument != null) {
                filters.add(this.withAskArgument.build());
            }
            if (this.withNearImageFilter != null) {
                filters.add(this.withNearImageFilter.build());
            }
            if (this.limit != null) {
                filters.add(String.format("limit: %s", this.limit));
            }
            if (this.objectLimit != null) {
                filters.add(String.format("objectLimit: %s", this.objectLimit));
            }
            return String.format("(%s)", StringUtils.joinWith((String)", ", (Object[])filters.toArray()));
        }
        return "";
    }

    @Override
    public String buildQuery() {
        String fieldsClause = this.fields != null ? this.fields.build() : "";
        return String.format("{Aggregate{%s%s{%s}}}", this.className, this.createFilterClause(), fieldsClause);
    }

    AggregateBuilder(String className, Fields fields, String groupByClausePropertyName, WhereFilter withWhereFilter, NearTextArgument withNearTextFilter, NearObjectArgument withNearObjectFilter, NearVectorArgument withNearVectorFilter, AskArgument withAskArgument, NearImageArgument withNearImageFilter, Integer objectLimit, Integer limit) {
        this.className = className;
        this.fields = fields;
        this.groupByClausePropertyName = groupByClausePropertyName;
        this.withWhereFilter = withWhereFilter;
        this.withNearTextFilter = withNearTextFilter;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withNearVectorFilter = withNearVectorFilter;
        this.withAskArgument = withAskArgument;
        this.withNearImageFilter = withNearImageFilter;
        this.objectLimit = objectLimit;
        this.limit = limit;
    }

    public static AggregateBuilderBuilder builder() {
        return new AggregateBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public Fields getFields() {
        return this.fields;
    }

    public String getGroupByClausePropertyName() {
        return this.groupByClausePropertyName;
    }

    public WhereFilter getWithWhereFilter() {
        return this.withWhereFilter;
    }

    public NearTextArgument getWithNearTextFilter() {
        return this.withNearTextFilter;
    }

    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    public NearVectorArgument getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    public Integer getObjectLimit() {
        return this.objectLimit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class AggregateBuilderBuilder {
        private String className;
        private Fields fields;
        private String groupByClausePropertyName;
        private WhereFilter withWhereFilter;
        private NearTextArgument withNearTextFilter;
        private NearObjectArgument withNearObjectFilter;
        private NearVectorArgument withNearVectorFilter;
        private AskArgument withAskArgument;
        private NearImageArgument withNearImageFilter;
        private Integer objectLimit;
        private Integer limit;

        AggregateBuilderBuilder() {
        }

        public AggregateBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public AggregateBuilderBuilder fields(Fields fields) {
            this.fields = fields;
            return this;
        }

        public AggregateBuilderBuilder groupByClausePropertyName(String groupByClausePropertyName) {
            this.groupByClausePropertyName = groupByClausePropertyName;
            return this;
        }

        public AggregateBuilderBuilder withWhereFilter(WhereFilter withWhereFilter) {
            this.withWhereFilter = withWhereFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearTextFilter(NearTextArgument withNearTextFilter) {
            this.withNearTextFilter = withNearTextFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        public AggregateBuilderBuilder withNearVectorFilter(NearVectorArgument withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        public AggregateBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        public AggregateBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        public AggregateBuilderBuilder objectLimit(Integer objectLimit) {
            this.objectLimit = objectLimit;
            return this;
        }

        public AggregateBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AggregateBuilder build() {
            return new AggregateBuilder(this.className, this.fields, this.groupByClausePropertyName, this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withAskArgument, this.withNearImageFilter, this.objectLimit, this.limit);
        }

        public String toString() {
            return "AggregateBuilder.AggregateBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", groupByClausePropertyName=" + this.groupByClausePropertyName + ", withWhereFilter=" + this.withWhereFilter + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", objectLimit=" + this.objectLimit + ", limit=" + this.limit + ")";
        }
    }
}

