/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;

public class NearVectorArgument
implements Argument {
    private final Float[] vector;
    private final Float certainty;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (this.vector != null) {
            arg.add(String.format("vector: %s", Arrays.toString((Object[])this.vector)));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty: %s", this.certainty));
        }
        return String.format("nearVector: {%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
    }

    NearVectorArgument(Float[] vector, Float certainty) {
        this.vector = vector;
        this.certainty = certainty;
    }

    public static NearVectorArgumentBuilder builder() {
        return new NearVectorArgumentBuilder();
    }

    public Float[] getVector() {
        return this.vector;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public static class NearVectorArgumentBuilder {
        private Float[] vector;
        private Float certainty;

        NearVectorArgumentBuilder() {
        }

        public NearVectorArgumentBuilder vector(Float[] vector) {
            this.vector = vector;
            return this;
        }

        public NearVectorArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearVectorArgument build() {
            return new NearVectorArgument(this.vector, this.certainty);
        }

        public String toString() {
            return "NearVectorArgument.NearVectorArgumentBuilder(vector=" + Arrays.deepToString(this.vector) + ", certainty=" + this.certainty + ")";
        }
    }
}

