// Generated by delombok at Wed May 25 09:10:50 UTC 2022
package technology.semi.weaviate.client.base;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Result<T> {
  private final T result;
  private final WeaviateError error;

  public Result(Response<T> response) {
    this(response.getStatusCode(), response.getBody(), response.getErrors());
  }

  public Result(int statusCode, T body, WeaviateErrorResponse errors) {
    if (errors != null && errors.getError() != null) {
      List<WeaviateErrorMessage> items = errors.getError().stream().filter(Objects::nonNull).collect(Collectors.toList());
      this.error = new WeaviateError(statusCode, items);
      this.result = null;
    } else if (errors != null && errors.getMessage() != null) {
      this.error = new WeaviateError(statusCode, Collections.singletonList(WeaviateErrorMessage.builder().message(errors.getMessage()).build()));
      this.result = null;
    } else {
      this.result = body;
      this.error = null;
    }
  }

  public boolean hasErrors() {
    return this.error != null;
  }

  @java.lang.SuppressWarnings("all")
  public T getResult() {
    return this.result;
  }

  @java.lang.SuppressWarnings("all")
  public WeaviateError getError() {
    return this.error;
  }
}
