// Generated by delombok at Tue Feb 08 22:36:55 UTC 2022
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class NearTextArgument implements Argument {
  private final String[] concepts;
  private final Float certainty;
  private final NearTextMoveParameters moveTo;
  private final NearTextMoveParameters moveAwayFrom;
  private final Boolean autocorrect;

  private String getConcepts(String[] concepts) {
    return Stream.of(concepts).map(f -> String.format("\"%s\"", f)).collect(Collectors.joining(", "));
  }

  private String buildMoveParam(String name, NearTextMoveParameters moveParam) {
    if (moveParam.getConcepts() != null && moveParam.getConcepts().length > 0) {
      Set<String> arg = new LinkedHashSet<>();
      arg.add(String.format("concepts: [%s]", getConcepts(moveParam.getConcepts())));
      if (moveParam.getForce() != null) {
        arg.add(String.format("force: %s", moveParam.getForce()));
      }
      return String.format("%s: {%s}", name, StringUtils.joinWith(" ", arg.toArray()));
    }
    return "";
  }

  @Override
  public String build() {
    if (concepts != null && concepts.length > 0) {
      Set<String> arg = new LinkedHashSet<>();
      arg.add(String.format("concepts: [%s]", getConcepts(concepts)));
      if (certainty != null) {
        arg.add(String.format("certainty: %s", certainty));
      }
      if (moveTo != null) {
        arg.add(buildMoveParam("moveTo", moveTo));
      }
      if (moveAwayFrom != null) {
        arg.add(buildMoveParam("moveAwayFrom", moveAwayFrom));
      }
      if (autocorrect != null) {
        arg.add(String.format("autocorrect: %s", autocorrect));
      }
      return String.format("nearText: {%s}", StringUtils.joinWith(" ", arg.toArray()));
    }
    return "";
  }

  @java.lang.SuppressWarnings("all")
  NearTextArgument(final String[] concepts, final Float certainty, final NearTextMoveParameters moveTo, final NearTextMoveParameters moveAwayFrom, final Boolean autocorrect) {
    this.concepts = concepts;
    this.certainty = certainty;
    this.moveTo = moveTo;
    this.moveAwayFrom = moveAwayFrom;
    this.autocorrect = autocorrect;
  }


  @java.lang.SuppressWarnings("all")
  public static class NearTextArgumentBuilder {
    @java.lang.SuppressWarnings("all")
    private String[] concepts;
    @java.lang.SuppressWarnings("all")
    private Float certainty;
    @java.lang.SuppressWarnings("all")
    private NearTextMoveParameters moveTo;
    @java.lang.SuppressWarnings("all")
    private NearTextMoveParameters moveAwayFrom;
    @java.lang.SuppressWarnings("all")
    private Boolean autocorrect;

    @java.lang.SuppressWarnings("all")
    NearTextArgumentBuilder() {
    }

    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder concepts(final String[] concepts) {
      this.concepts = concepts;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder certainty(final Float certainty) {
      this.certainty = certainty;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder moveTo(final NearTextMoveParameters moveTo) {
      this.moveTo = moveTo;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder moveAwayFrom(final NearTextMoveParameters moveAwayFrom) {
      this.moveAwayFrom = moveAwayFrom;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder autocorrect(final Boolean autocorrect) {
      this.autocorrect = autocorrect;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public NearTextArgument build() {
      return new NearTextArgument(this.concepts, this.certainty, this.moveTo, this.moveAwayFrom, this.autocorrect);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "NearTextArgument.NearTextArgumentBuilder(concepts=" + java.util.Arrays.deepToString(this.concepts) + ", certainty=" + this.certainty + ", moveTo=" + this.moveTo + ", moveAwayFrom=" + this.moveAwayFrom + ", autocorrect=" + this.autocorrect + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static NearTextArgument.NearTextArgumentBuilder builder() {
    return new NearTextArgument.NearTextArgumentBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String[] getConcepts() {
    return this.concepts;
  }

  @java.lang.SuppressWarnings("all")
  public Float getCertainty() {
    return this.certainty;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextMoveParameters getMoveTo() {
    return this.moveTo;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextMoveParameters getMoveAwayFrom() {
    return this.moveAwayFrom;
  }

  @java.lang.SuppressWarnings("all")
  public Boolean getAutocorrect() {
    return this.autocorrect;
  }
}
