/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;

public class AskArgument
implements Argument {
    private final String question;
    private final String[] properties;
    private final Float certainty;
    private final Boolean autocorrect;

    @Override
    public String build() {
        if (StringUtils.isNotBlank((CharSequence)this.question)) {
            LinkedHashSet<String> arg = new LinkedHashSet<String>();
            arg.add(String.format("question: \"%s\"", this.question));
            if (this.properties != null && this.properties.length > 0) {
                String props = Stream.of(this.properties).map(f -> String.format("\"%s\"", f)).collect(Collectors.joining(", "));
                arg.add(String.format("properties: [%s]", props));
            }
            if (this.certainty != null) {
                arg.add(String.format("certainty: %s", this.certainty));
            }
            if (this.autocorrect != null) {
                arg.add(String.format("autocorrect: %s", this.autocorrect));
            }
            return String.format("ask: {%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
        }
        return "";
    }

    AskArgument(String question, String[] properties, Float certainty, Boolean autocorrect) {
        this.question = question;
        this.properties = properties;
        this.certainty = certainty;
        this.autocorrect = autocorrect;
    }

    public static AskArgumentBuilder builder() {
        return new AskArgumentBuilder();
    }

    public String getQuestion() {
        return this.question;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Boolean getAutocorrect() {
        return this.autocorrect;
    }

    public static class AskArgumentBuilder {
        private String question;
        private String[] properties;
        private Float certainty;
        private Boolean autocorrect;

        AskArgumentBuilder() {
        }

        public AskArgumentBuilder question(String question) {
            this.question = question;
            return this;
        }

        public AskArgumentBuilder properties(String[] properties) {
            this.properties = properties;
            return this;
        }

        public AskArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public AskArgumentBuilder autocorrect(Boolean autocorrect) {
            this.autocorrect = autocorrect;
            return this;
        }

        public AskArgument build() {
            return new AskArgument(this.question, this.properties, this.certainty, this.autocorrect);
        }

        public String toString() {
            return "AskArgument.AskArgumentBuilder(question=" + this.question + ", properties=" + Arrays.deepToString(this.properties) + ", certainty=" + this.certainty + ", autocorrect=" + this.autocorrect + ")";
        }
    }
}

