/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.schema.model;

import java.util.List;

public class Property {
    private final String name;
    private final List<String> dataType;
    private final String description;
    private final Boolean indexInverted;
    private final Object moduleConfig;

    Property(String name, List<String> dataType, String description, Boolean indexInverted, Object moduleConfig) {
        this.name = name;
        this.dataType = dataType;
        this.description = description;
        this.indexInverted = indexInverted;
        this.moduleConfig = moduleConfig;
    }

    public static PropertyBuilder builder() {
        return new PropertyBuilder();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getDataType() {
        return this.dataType;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIndexInverted() {
        return this.indexInverted;
    }

    public Object getModuleConfig() {
        return this.moduleConfig;
    }

    public static class PropertyBuilder {
        private String name;
        private List<String> dataType;
        private String description;
        private Boolean indexInverted;
        private Object moduleConfig;

        PropertyBuilder() {
        }

        public PropertyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PropertyBuilder dataType(List<String> dataType) {
            this.dataType = dataType;
            return this;
        }

        public PropertyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public PropertyBuilder indexInverted(Boolean indexInverted) {
            this.indexInverted = indexInverted;
            return this;
        }

        public PropertyBuilder moduleConfig(Object moduleConfig) {
            this.moduleConfig = moduleConfig;
            return this;
        }

        public Property build() {
            return new Property(this.name, this.dataType, this.description, this.indexInverted, this.moduleConfig);
        }

        public String toString() {
            return "Property.PropertyBuilder(name=" + this.name + ", dataType=" + this.dataType + ", description=" + this.description + ", indexInverted=" + this.indexInverted + ", moduleConfig=" + this.moduleConfig + ")";
        }
    }
}

