/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.builder;

import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.builder.Query;
import technology.semi.weaviate.client.v1.graphql.query.fields.Fields;

public class AggregateBuilder
implements Query {
    private final String className;
    private final Fields fields;
    private final String groupByClausePropertyName;

    @Override
    public String buildQuery() {
        String filterClause = "";
        if (StringUtils.isNotBlank((CharSequence)this.groupByClausePropertyName)) {
            filterClause = String.format("(groupBy: \"%s\")", this.groupByClausePropertyName);
        }
        String fieldsClause = this.fields != null ? this.fields.build() : "";
        return String.format("{Aggregate{%s%s{%s}}}", this.className, filterClause, fieldsClause);
    }

    AggregateBuilder(String className, Fields fields, String groupByClausePropertyName) {
        this.className = className;
        this.fields = fields;
        this.groupByClausePropertyName = groupByClausePropertyName;
    }

    public static AggregateBuilderBuilder builder() {
        return new AggregateBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public Fields getFields() {
        return this.fields;
    }

    public String getGroupByClausePropertyName() {
        return this.groupByClausePropertyName;
    }

    public static class AggregateBuilderBuilder {
        private String className;
        private Fields fields;
        private String groupByClausePropertyName;

        AggregateBuilderBuilder() {
        }

        public AggregateBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public AggregateBuilderBuilder fields(Fields fields) {
            this.fields = fields;
            return this;
        }

        public AggregateBuilderBuilder groupByClausePropertyName(String groupByClausePropertyName) {
            this.groupByClausePropertyName = groupByClausePropertyName;
            return this;
        }

        public AggregateBuilder build() {
            return new AggregateBuilder(this.className, this.fields, this.groupByClausePropertyName);
        }

        public String toString() {
            return "AggregateBuilder.AggregateBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", groupByClausePropertyName=" + this.groupByClausePropertyName + ")";
        }
    }
}

