/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.argument;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.argument.Argument;
import technology.semi.weaviate.client.v1.graphql.query.argument.GeoCoordinatesParameter;
import technology.semi.weaviate.client.v1.graphql.query.argument.WhereFilter;
import technology.semi.weaviate.client.v1.graphql.query.argument.WhereOperator;

public class WhereArgument
implements Argument {
    private final WhereFilter[] operands;
    private final WhereOperator operator;
    private final String[] path;
    private final Integer valueInt;
    private final Double valueNumber;
    private final Boolean valueBoolean;
    private final String valueString;
    private final String valueText;
    private final Date valueDate;
    private final GeoCoordinatesParameter valueGeoRange;

    private String getWhereFilter() {
        return WhereFilter.builder().path(this.path).valueInt(this.valueInt).valueBoolean(this.valueBoolean).valueString(this.valueString).valueText(this.valueText).valueDate(this.valueDate).valueGeoRange(this.valueGeoRange).valueNumber(this.valueNumber).build().buildWhereFilter();
    }

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        String whereFilter = this.getWhereFilter();
        if (StringUtils.isNotBlank((CharSequence)whereFilter)) {
            arg.add(whereFilter);
        }
        if (this.operator != null) {
            arg.add(String.format("operator:%s", new Object[]{this.operator}));
        }
        if (this.operands != null && this.operands.length > 0) {
            LinkedHashSet<String> operandsSet = new LinkedHashSet<String>();
            for (WhereFilter f : this.operands) {
                operandsSet.add(String.format("{%s}", f.buildWhereFilter()));
            }
            arg.add(String.format("operands:[%s]", StringUtils.joinWith((String)",", (Object[])operandsSet.toArray())));
        }
        return String.format("where:{%s}", StringUtils.joinWith((String)" ", (Object[])arg.toArray()));
    }

    WhereArgument(WhereFilter[] operands, WhereOperator operator, String[] path, Integer valueInt, Double valueNumber, Boolean valueBoolean, String valueString, String valueText, Date valueDate, GeoCoordinatesParameter valueGeoRange) {
        this.operands = operands;
        this.operator = operator;
        this.path = path;
        this.valueInt = valueInt;
        this.valueNumber = valueNumber;
        this.valueBoolean = valueBoolean;
        this.valueString = valueString;
        this.valueText = valueText;
        this.valueDate = valueDate;
        this.valueGeoRange = valueGeoRange;
    }

    public static WhereArgumentBuilder builder() {
        return new WhereArgumentBuilder();
    }

    public WhereFilter[] getOperands() {
        return this.operands;
    }

    public WhereOperator getOperator() {
        return this.operator;
    }

    public String[] getPath() {
        return this.path;
    }

    public Integer getValueInt() {
        return this.valueInt;
    }

    public Double getValueNumber() {
        return this.valueNumber;
    }

    public Boolean getValueBoolean() {
        return this.valueBoolean;
    }

    public String getValueString() {
        return this.valueString;
    }

    public String getValueText() {
        return this.valueText;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public GeoCoordinatesParameter getValueGeoRange() {
        return this.valueGeoRange;
    }

    public static class WhereArgumentBuilder {
        private WhereFilter[] operands;
        private WhereOperator operator;
        private String[] path;
        private Integer valueInt;
        private Double valueNumber;
        private Boolean valueBoolean;
        private String valueString;
        private String valueText;
        private Date valueDate;
        private GeoCoordinatesParameter valueGeoRange;

        WhereArgumentBuilder() {
        }

        public WhereArgumentBuilder operands(WhereFilter[] operands) {
            this.operands = operands;
            return this;
        }

        public WhereArgumentBuilder operator(WhereOperator operator) {
            this.operator = operator;
            return this;
        }

        public WhereArgumentBuilder path(String[] path) {
            this.path = path;
            return this;
        }

        public WhereArgumentBuilder valueInt(Integer valueInt) {
            this.valueInt = valueInt;
            return this;
        }

        public WhereArgumentBuilder valueNumber(Double valueNumber) {
            this.valueNumber = valueNumber;
            return this;
        }

        public WhereArgumentBuilder valueBoolean(Boolean valueBoolean) {
            this.valueBoolean = valueBoolean;
            return this;
        }

        public WhereArgumentBuilder valueString(String valueString) {
            this.valueString = valueString;
            return this;
        }

        public WhereArgumentBuilder valueText(String valueText) {
            this.valueText = valueText;
            return this;
        }

        public WhereArgumentBuilder valueDate(Date valueDate) {
            this.valueDate = valueDate;
            return this;
        }

        public WhereArgumentBuilder valueGeoRange(GeoCoordinatesParameter valueGeoRange) {
            this.valueGeoRange = valueGeoRange;
            return this;
        }

        public WhereArgument build() {
            return new WhereArgument(this.operands, this.operator, this.path, this.valueInt, this.valueNumber, this.valueBoolean, this.valueString, this.valueText, this.valueDate, this.valueGeoRange);
        }

        public String toString() {
            return "WhereArgument.WhereArgumentBuilder(operands=" + Arrays.deepToString(this.operands) + ", operator=" + (Object)((Object)this.operator) + ", path=" + Arrays.deepToString(this.path) + ", valueInt=" + this.valueInt + ", valueNumber=" + this.valueNumber + ", valueBoolean=" + this.valueBoolean + ", valueString=" + this.valueString + ", valueText=" + this.valueText + ", valueDate=" + this.valueDate + ", valueGeoRange=" + this.valueGeoRange + ")";
        }
    }
}

