/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.builder;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.model.ExploreFields;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import technology.semi.weaviate.client.v1.graphql.query.builder.Query;

public class ExploreBuilder
implements Query {
    private final ExploreFields[] fields;
    private final NearTextArgument withNearText;

    private String createFilterClause() {
        LinkedHashSet<String> filters = new LinkedHashSet<String>();
        if (this.withNearText != null) {
            filters.add(this.withNearText.build());
        }
        return String.format("%s", StringUtils.joinWith((String)", ", (Object[])filters.toArray()));
    }

    @Override
    public String buildQuery() {
        String fieldsClause = "";
        if (this.fields != null && this.fields.length > 0) {
            fieldsClause = StringUtils.joinWith((String)", ", (Object[])((Object[])this.fields));
        }
        String filterClause = this.createFilterClause();
        return String.format("{Explore(%s){%s}}", filterClause, fieldsClause);
    }

    ExploreBuilder(ExploreFields[] fields, NearTextArgument withNearText) {
        this.fields = fields;
        this.withNearText = withNearText;
    }

    public static ExploreBuilderBuilder builder() {
        return new ExploreBuilderBuilder();
    }

    public ExploreFields[] getFields() {
        return this.fields;
    }

    public NearTextArgument getWithNearText() {
        return this.withNearText;
    }

    public static class ExploreBuilderBuilder {
        private ExploreFields[] fields;
        private NearTextArgument withNearText;

        ExploreBuilderBuilder() {
        }

        public ExploreBuilderBuilder fields(ExploreFields[] fields) {
            this.fields = fields;
            return this;
        }

        public ExploreBuilderBuilder withNearText(NearTextArgument withNearText) {
            this.withNearText = withNearText;
            return this;
        }

        public ExploreBuilder build() {
            return new ExploreBuilder(this.fields, this.withNearText);
        }

        public String toString() {
            return "ExploreBuilder.ExploreBuilderBuilder(fields=" + Arrays.deepToString((Object[])this.fields) + ", withNearText=" + this.withNearText + ")";
        }
    }
}

