/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.builder;

import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.graphql.query.builder.Query;

public class AggregateBuilder
implements Query {
    private final String className;
    private final String fields;
    private final String groupByClausePropertyName;

    @Override
    public String buildQuery() {
        String filterClause = "";
        if (StringUtils.isNotBlank((CharSequence)this.groupByClausePropertyName)) {
            filterClause = String.format("(groupBy: \"%s\")", this.groupByClausePropertyName);
        }
        return String.format("{Aggregate{%s%s{%s}}}", this.className, filterClause, this.fields);
    }

    AggregateBuilder(String className, String fields, String groupByClausePropertyName) {
        this.className = className;
        this.fields = fields;
        this.groupByClausePropertyName = groupByClausePropertyName;
    }

    public static AggregateBuilderBuilder builder() {
        return new AggregateBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFields() {
        return this.fields;
    }

    public String getGroupByClausePropertyName() {
        return this.groupByClausePropertyName;
    }

    public static class AggregateBuilderBuilder {
        private String className;
        private String fields;
        private String groupByClausePropertyName;

        AggregateBuilderBuilder() {
        }

        public AggregateBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public AggregateBuilderBuilder fields(String fields) {
            this.fields = fields;
            return this;
        }

        public AggregateBuilderBuilder groupByClausePropertyName(String groupByClausePropertyName) {
            this.groupByClausePropertyName = groupByClausePropertyName;
            return this;
        }

        public AggregateBuilder build() {
            return new AggregateBuilder(this.className, this.fields, this.groupByClausePropertyName);
        }

        public String toString() {
            return "AggregateBuilder.AggregateBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", groupByClausePropertyName=" + this.groupByClausePropertyName + ")";
        }
    }
}

