/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.data.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.Config;
import technology.semi.weaviate.client.base.BaseClient;
import technology.semi.weaviate.client.base.ClientResult;
import technology.semi.weaviate.client.base.Response;
import technology.semi.weaviate.client.base.Result;
import technology.semi.weaviate.client.v1.data.model.ObjectsListResponse;
import technology.semi.weaviate.client.v1.data.model.WeaviateObject;

public class ObjectsGetter
extends BaseClient<ObjectsListResponse>
implements ClientResult<List<WeaviateObject>> {
    private String id;
    private Integer limit;
    private HashSet<String> additional;
    private ObjectGetter objectGetter;

    public ObjectsGetter(Config config) {
        super(config);
        this.objectGetter = new ObjectGetter(config);
        this.additional = new HashSet();
    }

    public ObjectsGetter withID(String id) {
        this.id = id;
        return this;
    }

    public ObjectsGetter withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public ObjectsGetter withVector() {
        this.additional.add("vector");
        return this;
    }

    public ObjectsGetter withAdditional(String name) {
        this.additional.add(name);
        return this;
    }

    private String getPath() {
        StringBuilder path = new StringBuilder();
        path.append("/objects");
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            path.append("/").append(this.id);
        }
        ArrayList<String> params = new ArrayList<String>();
        if (this.additional.size() > 0) {
            params.add(String.format("include=%s", StringUtils.joinWith((String)",", (Object[])this.additional.toArray())));
        }
        if (this.limit != null) {
            params.add(String.format("limit=%s", this.limit));
        }
        if (params.size() > 0) {
            path.append("?").append(StringUtils.joinWith((String)"&", (Object[])params.toArray()));
        }
        return path.toString();
    }

    @Override
    public Result<List<WeaviateObject>> run() {
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            return this.objectGetter.withPath(this.getPath()).run();
        }
        Response<ObjectsListResponse> resp = this.sendGetRequest(this.getPath(), ObjectsListResponse.class);
        return new Result<List<WeaviateObject>>(resp.getStatusCode(), Arrays.asList(resp.getBody().getObjects()), resp.getErrors());
    }

    private class ObjectGetter
    extends BaseClient<WeaviateObject>
    implements ClientResult<List<WeaviateObject>> {
        private String path;

        public ObjectGetter(Config config) {
            super(config);
        }

        public ObjectGetter withPath(String path) {
            this.path = path;
            return this;
        }

        @Override
        public Result<List<WeaviateObject>> run() {
            Response<WeaviateObject> resp = this.sendGetRequest(this.path, WeaviateObject.class);
            return new Result<List<WeaviateObject>>(resp.getStatusCode(), Arrays.asList(resp.getBody()), resp.getErrors());
        }
    }
}

