/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.base;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import technology.semi.weaviate.client.base.Response;
import technology.semi.weaviate.client.base.WeaviateError;
import technology.semi.weaviate.client.base.WeaviateErrorMessage;
import technology.semi.weaviate.client.base.WeaviateErrorResponse;

public class Result<T> {
    private final T result;
    private final WeaviateError error;

    public Result(Response<T> response) {
        this(response.getStatusCode(), response.getBody(), response.getErrors());
    }

    public Result(int statusCode, T body, WeaviateErrorResponse errors) {
        if (errors != null && errors.getError() != null) {
            List<WeaviateErrorMessage> items = errors.getError().stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.error = new WeaviateError(statusCode, items);
            this.result = null;
        } else {
            this.result = body;
            this.error = null;
        }
    }

    public boolean hasErrors() {
        return this.error != null;
    }

    public T getResult() {
        return this.result;
    }

    public WeaviateError getError() {
        return this.error;
    }
}

