/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.decorator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.api.IpInformation;
import technology.dice.dicewhere.decorator.DecorationRangePoint;
import technology.dice.dicewhere.decorator.DecorationStrategy;
import technology.dice.dicewhere.decorator.DecoratorDbReader;
import technology.dice.dicewhere.decorator.DecoratorInformation;
import technology.dice.dicewhere.decorator.RangePoint;
import technology.dice.dicewhere.utils.IPUtils;

public abstract class Decorator<T extends DecoratorInformation> {
    private final Map<Integer, DecoratorDbReader<T>> databaseReaders;
    private final DecorationStrategy decorationStrategy;

    Decorator(@NotNull Collection<DecoratorDbReader<T>> databaseReaders, @NotNull DecorationStrategy decorationStrategy) {
        Objects.requireNonNull(databaseReaders);
        Objects.requireNonNull(decorationStrategy);
        if (databaseReaders.isEmpty()) {
            throw new IllegalArgumentException("Database readers can't be empty");
        }
        AtomicInteger counter = new AtomicInteger(0);
        this.databaseReaders = (Map)databaseReaders.stream().collect(ImmutableMap.toImmutableMap(e -> counter.getAndIncrement(), Function.identity()));
        this.decorationStrategy = decorationStrategy;
    }

    public Stream<IpInformation> decorate(IpInformation original) throws UnknownHostException {
        Objects.requireNonNull(original);
        List extraInformation = (List)this.databaseReaders.values().stream().map(tDecoratorDbReader -> tDecoratorDbReader.fetchForRange(original.getStartOfRange(), original.getEndOfRange())).collect(ImmutableList.toImmutableList());
        return this.mergeIpInfoWithDecoratorInformation(original, this.mergeDecorationRanges(extraInformation));
    }

    private List<T> mergeDecorationRanges(Collection<List<T>> found) throws UnknownHostException {
        int filterThreshold;
        List foundRangesList = (List)found.stream().flatMap(Collection::stream).sorted(Comparator.comparing(DecoratorInformation::getRangeStart).thenComparing(DecoratorInformation::getRangeEnd)).collect(ImmutableList.toImmutableList());
        if (foundRangesList.isEmpty()) {
            return ImmutableList.of();
        }
        List<RangePoint<T>> splits = this.getRangePointsFromMatchedRanges(foundRangesList);
        List<T> allValidRanges = this.getAllValidSplitRanges(splits, filterThreshold = this.getFilterThreshold());
        if (allValidRanges.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<DecoratorInformation> mergedResults = new ArrayList<DecoratorInformation>();
        mergedResults.add((DecoratorInformation)allValidRanges.get(0));
        for (int i = 1; i < allValidRanges.size(); ++i) {
            if (((DecoratorInformation)allValidRanges.get(i)).getRangeStart().isGreaterThan(IPUtils.increment(((DecoratorInformation)mergedResults.get(mergedResults.size() - 1)).getRangeEnd()))) {
                mergedResults.add((DecoratorInformation)allValidRanges.get(i));
                continue;
            }
            IP start = ((DecoratorInformation)mergedResults.get(mergedResults.size() - 1)).getRangeStart();
            IP end = ((DecoratorInformation)allValidRanges.get(i)).getRangeEnd();
            mergedResults.set(mergedResults.size() - 1, (DecoratorInformation)((DecoratorInformation)allValidRanges.get(i)).withNewRange(start, end));
        }
        return ImmutableList.copyOf(mergedResults);
    }

    @NotNull
    private List<T> getAllValidSplitRanges(List<RangePoint<T>> splits, int filterThreshold) throws UnknownHostException {
        ImmutableList.Builder allValidRanges = ImmutableList.builder();
        int rangeNestingLevel = 1;
        for (int i = 1; i < splits.size(); ++i) {
            IP end;
            IP start;
            if (splits.get(i).isEnd()) {
                if (splits.get(i - 1).isStart()) {
                    int rangeDiffCoverage;
                    if (Math.max(((DecoratorInformation)splits.get(i).getRangeInfo()).getNumberOfMatches(), rangeNestingLevel) >= filterThreshold) {
                        IP splitStart = splits.get(i - 1).getIp();
                        IP splitEnd = new IP(IPUtils.from(splits.get(i).getIp().getBytes()).getBytes());
                        allValidRanges.add(((DecoratorInformation)splits.get(i - 1).getRangeInfo()).withNewRange(splitStart, splitEnd));
                    }
                    if (rangeNestingLevel > 1 && (rangeDiffCoverage = Math.max(rangeNestingLevel - 1, Math.min(((DecoratorInformation)splits.get(i - 2).getRangeInfo()).getNumberOfMatches(), ((DecoratorInformation)splits.get(i - 1).getRangeInfo()).getNumberOfMatches()) - 1)) >= filterThreshold) {
                        IP start2 = splits.get(i - 2).getIp();
                        IP nextSplitStart = splits.get(i - 1).getIp();
                        if (new IP(IPUtils.from(start2.getBytes()).increment(1L).getBytes()).isLowerThan(nextSplitStart)) {
                            allValidRanges.add(((DecoratorInformation)splits.get(i - 2).getRangeInfo()).withNumberOfMatches(((DecoratorInformation)splits.get(i - 1).getRangeInfo()).getNumberOfMatches() - 1).withNewRange(start2, nextSplitStart));
                        }
                    }
                } else {
                    IP prevSplitEnd;
                    IP end2 = splits.get(i).getIp();
                    if (!end2.equals(prevSplitEnd = splits.get(i - 1).getIp()) && Math.max(((DecoratorInformation)splits.get(i).getRangeInfo()).getNumberOfMatches(), rangeNestingLevel) >= filterThreshold) {
                        allValidRanges.add(((DecoratorInformation)splits.get(i).getRangeInfo()).withNewRange(new IP(IPUtils.from(prevSplitEnd.getBytes()).increment(1L).getBytes()), end2));
                    }
                }
            } else if (splits.get(i).isStart() && rangeNestingLevel >= filterThreshold && (start = IPUtils.increment(splits.get(i - 1).getIp())).isLowerThan(end = IPUtils.decrement(splits.get(i).getIp()))) {
                allValidRanges.add(((DecoratorInformation)splits.get(i).getRangeInfo()).withNewRange(start, end).withNumberOfMatches(rangeNestingLevel));
            }
            if (splits.get(i).isStart()) {
                ++rangeNestingLevel;
                continue;
            }
            --rangeNestingLevel;
        }
        return ImmutableList.sortedCopyOf(Comparator.comparing(DecoratorInformation::getRangeStart).thenComparing(DecoratorInformation::getRangeEnd), (Iterable)allValidRanges.build());
    }

    private int getFilterThreshold() {
        int filterThreshold;
        switch (this.decorationStrategy) {
            case ALL: {
                filterThreshold = this.databaseReaders.keySet().size();
                break;
            }
            case MAJORITY: {
                filterThreshold = (this.databaseReaders.keySet().size() + 1) / 2;
                break;
            }
            default: {
                filterThreshold = 1;
            }
        }
        return filterThreshold;
    }

    @NotNull
    private List<RangePoint<T>> getRangePointsFromMatchedRanges(List<T> foundRangesList) {
        ArrayList splits = new ArrayList();
        Iterator<T> sourceIterator = foundRangesList.iterator();
        int counter = 0;
        while (sourceIterator.hasNext()) {
            DecoratorInformation sourceItem = (DecoratorInformation)sourceIterator.next();
            int duplicates = 0;
            while (sourceIterator.hasNext() && ((DecoratorInformation)foundRangesList.get(counter + 1)).equals(sourceItem)) {
                ++duplicates;
                ++counter;
                sourceIterator.next();
            }
            Object t = sourceItem.withNumberOfMatches(sourceItem.getNumberOfMatches() + duplicates);
            splits.add(new RangePoint(sourceItem.getRangeStart(), true, t));
            splits.add(new RangePoint(sourceItem.getRangeEnd(), false, t));
            ++counter;
        }
        return ImmutableList.sortedCopyOf(Comparator.comparing(RangePoint::getIp), splits);
    }

    private Stream<IpInformation> mergeIpInfoWithDecoratorInformation(IpInformation original, List<T> decoratorInfo) throws UnknownHostException {
        if (decoratorInfo.isEmpty()) {
            return Stream.of(original);
        }
        if (decoratorInfo.size() == 1 && ((DecoratorInformation)decoratorInfo.get(0)).getRangeStart().equals(original.getStartOfRange()) && ((DecoratorInformation)decoratorInfo.get(0)).getRangeEnd().equals(original.getEndOfRange())) {
            return Stream.of(this.decorateIpInformationMatch(original, new DecorationRangePoint<Optional<T>>(((DecoratorInformation)decoratorInfo.get(0)).getRangeStart(), true, Optional.of((DecoratorInformation)decoratorInfo.get(0)), original), original.getStartOfRange(), original.getEndOfRange()));
        }
        ImmutableList.Builder splitsBuilder = ImmutableList.builder();
        for (DecoratorInformation vdi : decoratorInfo) {
            splitsBuilder.add(new DecorationRangePoint<Optional<DecoratorInformation>>(vdi.getRangeStart(), true, Optional.of(vdi), original));
            splitsBuilder.add(new DecorationRangePoint<Optional<DecoratorInformation>>(vdi.getRangeEnd(), false, Optional.of(vdi), original));
        }
        splitsBuilder.addAll(this.fillRangeGaps(original, (List<DecorationRangePoint<Optional<T>>>)ImmutableList.sortedCopyOf(Comparator.comparing(RangePoint::getIp), (Iterable)splitsBuilder.build())));
        ImmutableList splits = ImmutableList.sortedCopyOf(Comparator.comparing(RangePoint::getIp), (Iterable)splitsBuilder.build());
        Stream.Builder<IpInformation> result = Stream.builder();
        int inRangeCounter = 1;
        for (int i = 1; i < splits.size(); ++i) {
            if (inRangeCounter > 0) {
                IpInformation decorated;
                IP end;
                IP start;
                IpInformation ipInfo = ((DecorationRangePoint)splits.get(i)).getIpInformation();
                if (inRangeCounter >= 1 && ((Optional)((DecorationRangePoint)splits.get(i)).getRangeInfo()).isPresent()) {
                    start = ((DecorationRangePoint)splits.get(i - 1)).getIp();
                    end = ((DecorationRangePoint)splits.get(i)).getIp();
                    decorated = this.decorateIpInformationMatch(ipInfo, (DecorationRangePoint)splits.get(i), start, end);
                } else {
                    start = ((DecorationRangePoint)splits.get(i - 1)).getIp();
                    end = ((DecorationRangePoint)splits.get(i)).getIp();
                    decorated = this.decorateIpInformationMiss(ipInfo, (DecorationRangePoint)splits.get(i), start, end);
                }
                result.add(decorated);
            }
            if (((DecorationRangePoint)splits.get(i)).isStart()) {
                ++inRangeCounter;
                continue;
            }
            --inRangeCounter;
        }
        return result.build();
    }

    private Set<? extends DecorationRangePoint<Optional<T>>> fillRangeGaps(IpInformation original, List<DecorationRangePoint<Optional<T>>> splits) throws UnknownHostException {
        ImmutableSet.Builder result = ImmutableSet.builder();
        IP lookupStart = original.getStartOfRange();
        IP lookupEnd = original.getEndOfRange();
        int inSplitRange = 0;
        for (int i = 0; i < splits.size(); ++i) {
            if (inSplitRange <= 0 && splits.get(i).getIp().isGreaterThan(lookupStart)) {
                result.add(new DecorationRangePoint(lookupStart, true, Optional.empty(), original));
                result.add(new DecorationRangePoint(new IP(IPUtils.from(splits.get(i).getIp().getBytes()).increment(-1L).getBytes()), false, Optional.empty(), original));
            }
            if (splits.get(i).isStart()) {
                ++inSplitRange;
                continue;
            }
            --inSplitRange;
            lookupStart = new IP(IPUtils.from(splits.get(i).getIp().getBytes()).increment(1L).getBytes());
        }
        if (lookupEnd.isGreaterThan(splits.get(splits.size() - 1).getIp())) {
            result.add(new DecorationRangePoint(new IP(IPUtils.from(splits.get(splits.size() - 1).getIp().getBytes()).increment(1L).getBytes()), true, Optional.empty(), original));
            result.add(new DecorationRangePoint(lookupEnd, false, Optional.empty(), original));
        }
        return result.build();
    }

    abstract IpInformation decorateIpInformationMatch(IpInformation var1, DecorationRangePoint<Optional<T>> var2, IP var3, IP var4);

    abstract IpInformation decorateIpInformationMiss(IpInformation var1, DecorationRangePoint<Optional<T>> var2, IP var3, IP var4);
}

