/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.api.api;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.lineprocessing.serializers.protobuf.ThreeStateValueProto;
import technology.dice.dicewhere.utils.ProtoValueConverter;
import technology.dice.dicewhere.utils.StringUtils;

public class IpInformation {
    private final String originalLine;
    private final String countryCodeAlpha2;
    private final String geonameId;
    private final String city;
    private final String leastSpecificDivision;
    private final String mostSpecificDivision;
    private final String postcode;
    private final Boolean isVpn;
    private final Boolean isHostingProvider;
    private final IP startOfRange;
    private final IP endOfRange;

    public IpInformation(@Nonnull String countryCodeAlpha2, @Nullable String geonameId, @Nullable String city, @Nullable String leastSpecificDivision, @Nullable String mostSpecificDivision, @Nullable String postcode, @Nonnull IP startOfRange, @Nonnull IP endOfRange, @Nullable String originalLine, @Nullable Boolean isVpn, @Nullable Boolean isHostingProvider) {
        this.countryCodeAlpha2 = Objects.requireNonNull(countryCodeAlpha2);
        this.geonameId = geonameId;
        this.city = city;
        this.leastSpecificDivision = leastSpecificDivision;
        this.mostSpecificDivision = mostSpecificDivision;
        this.postcode = postcode;
        this.startOfRange = Objects.requireNonNull(startOfRange);
        this.endOfRange = Objects.requireNonNull(endOfRange);
        this.originalLine = originalLine;
        this.isVpn = isVpn;
        this.isHostingProvider = isHostingProvider;
    }

    public String getCountryCodeAlpha2() {
        return this.countryCodeAlpha2;
    }

    public Optional<String> getGeonameId() {
        return StringUtils.nonEmptyString(this.geonameId);
    }

    public Optional<String> getCity() {
        return StringUtils.nonEmptyString(this.city);
    }

    public Optional<String> getLeastSpecificDivision() {
        return StringUtils.nonEmptyString(this.leastSpecificDivision);
    }

    public Optional<String> getMostSpecificDivision() {
        return StringUtils.nonEmptyString(this.mostSpecificDivision);
    }

    public Optional<String> getPostcode() {
        return StringUtils.nonEmptyString(this.postcode);
    }

    public IP getStartOfRange() {
        return this.startOfRange;
    }

    public IP getEndOfRange() {
        return this.endOfRange;
    }

    public Optional<String> getOriginalLine() {
        return StringUtils.nonEmptyString(this.originalLine);
    }

    public Optional<Boolean> isVpn() {
        return Optional.ofNullable(this.isVpn);
    }

    public Optional<Boolean> isHostingProvider() {
        return Optional.ofNullable(this.isHostingProvider);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpInformation)) {
            return false;
        }
        IpInformation that = (IpInformation)o;
        return Objects.equals(this.getOriginalLine(), that.getOriginalLine()) && Objects.equals(this.getCountryCodeAlpha2(), that.getCountryCodeAlpha2()) && Objects.equals(this.getGeonameId(), that.getGeonameId()) && Objects.equals(this.getCity(), that.getCity()) && Objects.equals(this.getLeastSpecificDivision(), that.getLeastSpecificDivision()) && Objects.equals(this.getMostSpecificDivision(), that.getMostSpecificDivision()) && Objects.equals(this.getPostcode(), that.getPostcode()) && Objects.equals(this.getStartOfRange(), that.getStartOfRange()) && Objects.equals(this.isVpn(), that.isVpn()) && Objects.equals(this.getEndOfRange(), that.getEndOfRange());
    }

    public int hashCode() {
        return Objects.hash(this.originalLine, this.countryCodeAlpha2, this.geonameId, this.city, this.leastSpecificDivision, this.mostSpecificDivision, this.postcode, this.startOfRange, this.endOfRange, this.isVpn);
    }

    public String toString() {
        return "IpInformation{originalLine='" + this.originalLine + '\'' + ", countryCodeAlpha2='" + this.countryCodeAlpha2 + '\'' + ", geonameId='" + this.geonameId + '\'' + ", city='" + this.city + '\'' + ", leastSpecificDivision='" + this.leastSpecificDivision + '\'' + ", mostSpecificDivision='" + this.mostSpecificDivision + '\'' + ", postcode='" + this.postcode + '\'' + ", isVpn=" + this.isVpn + ", startOfRange=" + this.startOfRange + ", endOfRange=" + this.endOfRange + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IpInformation info) {
        return new Builder().withCountryCodeAlpha2(info.getCountryCodeAlpha2()).withEndOfRange(info.getEndOfRange()).withStartOfRange(info.getStartOfRange()).withGeonameId(info.getGeonameId().orElse(null)).withCity(info.getCity().orElse(null)).withLeastSpecificDivision(info.getLeastSpecificDivision().orElse(null)).withPostcode(info.getPostcode().orElse(null)).withMostSpecificDivision(info.getMostSpecificDivision().orElse(null)).withOriginalLine(info.getOriginalLine().orElse(null)).isHostingProvider(info.isHostingProvider().orElse(null)).isVpn(info.isVpn());
    }

    public static class Builder {
        private String countryCodeAlpha2;
        private String geonameId;
        private String city;
        private String leastSpecificDivision;
        private String mostSpecificDivision;
        private String postcode;
        private IP startOfRange;
        private IP endOfRange;
        private String originalLine;
        private Boolean isVpn;
        private Boolean isHostingProvider;

        private Builder() {
        }

        public Builder withCountryCodeAlpha2(String countryCodeAlpha2) {
            this.countryCodeAlpha2 = Objects.requireNonNull(countryCodeAlpha2);
            return this;
        }

        public Builder withGeonameId(String geonameId) {
            this.geonameId = geonameId;
            return this;
        }

        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        public Builder withLeastSpecificDivision(String leastSpecificDivision) {
            this.leastSpecificDivision = leastSpecificDivision;
            return this;
        }

        public Builder withMostSpecificDivision(String mostSpecificDivision) {
            this.mostSpecificDivision = mostSpecificDivision;
            return this;
        }

        public Builder withPostcode(String postcode) {
            this.postcode = postcode;
            return this;
        }

        public Builder withStartOfRange(IP startOfRange) {
            this.startOfRange = Objects.requireNonNull(startOfRange);
            return this;
        }

        public Builder withEndOfRange(IP endOfRange) {
            this.endOfRange = Objects.requireNonNull(endOfRange);
            return this;
        }

        public Builder withOriginalLine(String originalLine) {
            this.originalLine = originalLine;
            return this;
        }

        public Builder isVpn(Optional<Boolean> isVpn) {
            this.isVpn = isVpn.orElse(null);
            return this;
        }

        public Builder isVpn(boolean isVpn) {
            this.isVpn = isVpn;
            return this;
        }

        public Builder isHostingProvider(Boolean isHostingProvider) {
            this.isHostingProvider = isHostingProvider;
            return this;
        }

        public Builder isVpn(ThreeStateValueProto.ThreeStateValue isVpn) {
            this.isVpn = ProtoValueConverter.parseThreeStateProto(isVpn).orElse(null);
            return this;
        }

        public IpInformation build() {
            return new IpInformation(Objects.requireNonNull(this.countryCodeAlpha2), this.geonameId, this.city, this.leastSpecificDivision, this.mostSpecificDivision, this.postcode, Objects.requireNonNull(this.startOfRange), Objects.requireNonNull(this.endOfRange), this.originalLine, this.isVpn, this.isHostingProvider);
        }
    }
}

