/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.decorator;

import com.google.common.collect.ImmutableList;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.exceptions.DecoratorDatabaseOutOfOrderException;
import technology.dice.dicewhere.decorator.DecoratorInformation;
import technology.dice.dicewhere.utils.IPUtils;

public abstract class DecoratorDbReader<T extends DecoratorInformation> {
    private T lastFetched;

    protected Optional<T> getLastFetched() {
        return Optional.ofNullable(this.lastFetched);
    }

    protected void setLastFetched(T lastFetched) {
        this.lastFetched = lastFetched;
    }

    public final List<T> fetchForRange(IP rangeBoundStart, IP rangeBoundEnd) {
        if (!this.getLastFetched().isPresent()) {
            return ImmutableList.of();
        }
        Stream.Builder result = Stream.builder();
        do {
            Optional resultRange;
            if ((resultRange = this.getLastFetched().flatMap(l -> this.fitToRange(l, rangeBoundStart, rangeBoundEnd))).isPresent()) {
                result.add(resultRange.get());
                if (this.isLastLineRangeContainingTargetRange(rangeBoundStart, rangeBoundEnd)) break;
            }
            if (this.isFinishingAfter(rangeBoundEnd)) continue;
            Optional<T> lastReadLine = this.readNextLine();
            if (lastReadLine.isPresent() && this.getLastFetched().isPresent() && ((DecoratorInformation)lastReadLine.get()).getRangeStart().isLowerThanOrEqual(((DecoratorInformation)this.getLastFetched().get()).getRangeEnd())) {
                try {
                    throw new DecoratorDatabaseOutOfOrderException(String.format("Ranges out of line for %s - %s", IPUtils.from(((DecoratorInformation)lastReadLine.get()).getRangeStart()), IPUtils.from(((DecoratorInformation)lastReadLine.get()).getRangeEnd())));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            this.setLastFetched(lastReadLine.orElse(null));
        } while (this.isLastLineBeforeRange(rangeBoundEnd) || this.isLastLineInRange(rangeBoundStart, rangeBoundEnd));
        return (List)result.build().collect(ImmutableList.toImmutableList());
    }

    protected abstract Optional<T> readNextLine();

    private boolean isLastLineRangeContainingTargetRange(IP targetRangeStart, IP targetRangeEnd) {
        return this.getLastFetched().map(a -> a.getRangeStart().isLowerThanOrEqual(targetRangeStart) && a.getRangeEnd().isGreaterThanOrEqual(targetRangeEnd)).orElse(false);
    }

    private boolean isLastLineBeforeRange(IP targetRangeStart) {
        return this.getLastFetched().map(a -> targetRangeStart.isGreaterThan(a.getRangeEnd())).orElse(false);
    }

    private boolean isLastLineAfterRange(IP targetEndStart) {
        return this.getLastFetched().map(a -> targetEndStart.isLowerThan(a.getRangeStart())).orElse(false);
    }

    private boolean isLastLineInRange(IP targetRangeStart, IP targetRangeEnd) {
        return this.getLastFetched().map(a -> {
            IP lastFetchedRangeStart = a.getRangeStart();
            IP lastFetchedRangeEnd = a.getRangeEnd();
            return targetRangeStart.isLowerThanOrEqual(lastFetchedRangeStart) && targetRangeEnd.isGreaterThanOrEqual(lastFetchedRangeStart) || targetRangeStart.isLowerThanOrEqual(lastFetchedRangeEnd) && targetRangeEnd.isGreaterThanOrEqual(lastFetchedRangeEnd);
        }).orElse(false);
    }

    private boolean isFinishingAfter(IP targetRangeEnd) {
        return this.getLastFetched().map(a -> a.getRangeEnd().isGreaterThan(targetRangeEnd)).orElse(false);
    }

    private Optional<T> fitToRange(T lastLine, IP rangeLowerBound, IP rangeUpperBound) {
        IP lastLineLowerBound = lastLine.getRangeStart();
        IP lastLineUpperBound = lastLine.getRangeEnd();
        if (this.isLastLineBeforeRange(rangeLowerBound) || this.isLastLineAfterRange(rangeUpperBound)) {
            return Optional.empty();
        }
        boolean toModify = false;
        if (lastLineLowerBound.isLowerThan(rangeLowerBound)) {
            lastLineLowerBound = rangeLowerBound;
            toModify = true;
        }
        if (lastLineUpperBound.isGreaterThan(rangeUpperBound)) {
            lastLineUpperBound = rangeUpperBound;
            toModify = true;
        }
        if (!toModify) {
            return Optional.of(lastLine);
        }
        return Optional.of(this.updateRange(lastLine, lastLineLowerBound, lastLineUpperBound));
    }

    private T updateRange(T original, IP lowerBound, IP upperBound) {
        return original.withNewRange(lowerBound, upperBound);
    }

    protected abstract Optional<T> parseDbLine(String var1);
}

