/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.provider.dbip.parsing;

import com.google.common.base.Splitter;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.api.IpInformation;
import technology.dice.dicewhere.api.exceptions.LineParsingException;
import technology.dice.dicewhere.decorator.Decorator;
import technology.dice.dicewhere.decorator.DecoratorInformation;
import technology.dice.dicewhere.parsing.LineParser;
import technology.dice.dicewhere.reading.RawLine;
import technology.dice.dicewhere.utils.StringUtils;

public class DbIpIpToCountryLiteCSVLineParser
extends LineParser {
    private static final Splitter splitter = Splitter.on((char)',');
    private final Decorator<? extends DecoratorInformation> decorator;

    public DbIpIpToCountryLiteCSVLineParser() {
        this(null);
    }

    public DbIpIpToCountryLiteCSVLineParser(Decorator<? extends DecoratorInformation> decorator) {
        this.decorator = decorator;
    }

    @Override
    public Optional<Decorator<? extends DecoratorInformation>> getDecorator() {
        return Optional.ofNullable(this.decorator);
    }

    @Override
    protected IpInformation parseLine(RawLine line, boolean retainOriginalLine) throws LineParsingException {
        try {
            Iterable fieldsIterable = splitter.split((CharSequence)line.getLine());
            Iterator fieldsIterator = fieldsIterable.iterator();
            String rangeStartString = StringUtils.removeQuotes((String)fieldsIterator.next());
            String rangeEndString = StringUtils.removeQuotes((String)fieldsIterator.next());
            String countryCode = (String)fieldsIterator.next();
            InetAddress e = InetAddresses.forString((String)rangeEndString);
            InetAddress s = InetAddresses.forString((String)rangeStartString);
            IP startIp = new IP(s);
            IP endIp = new IP(e);
            return IpInformation.builder().withCountryCodeAlpha2(StringUtils.removeQuotes(countryCode)).withStartOfRange(startIp).withEndOfRange(endIp).withOriginalLine(retainOriginalLine ? line.getLine() : null).build();
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            throw new LineParsingException(e, line);
        }
    }
}

