/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.provider.maxmind.reading;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import technology.dice.dicewhere.parsing.LineParser;
import technology.dice.dicewhere.provider.ProviderKey;
import technology.dice.dicewhere.provider.maxmind.MaxmindProviderKey;
import technology.dice.dicewhere.provider.maxmind.parsing.MaxmindLineParser;
import technology.dice.dicewhere.provider.maxmind.reading.MaxmindLocation;
import technology.dice.dicewhere.provider.maxmind.reading.MaxmindLocationsParser;
import technology.dice.dicewhere.reading.LineReader;

public class MaxmindDbReader
extends LineReader {
    private static final int BUFFER_SIZE = 0x100000;
    private final MaxmindLineParser parser;
    private final Path ipV4CSVPath;
    private final Path ipV6CSVPath;

    public MaxmindDbReader(Path locationNames, Path ipV4CSV, Path ipV6CSV) throws IOException {
        this.ipV4CSVPath = ipV4CSV;
        this.ipV6CSVPath = ipV6CSV;
        MaxmindLocationsParser locationsParser = new MaxmindLocationsParser();
        Map<String, MaxmindLocation> locations = locationsParser.locations(this.bufferedReaderForPath(locationNames, 0x100000));
        this.parser = new MaxmindLineParser(locations);
    }

    @Override
    public LineParser parser() {
        return this.parser;
    }

    @Override
    protected Stream<String> lines() throws IOException {
        BufferedReader ipV4ChannelBufferedReader = this.bufferedReaderForPath(this.ipV4CSVPath, 0x100000);
        BufferedReader ipV6ChannelBufferedReader = this.bufferedReaderForPath(this.ipV6CSVPath, 0x100000);
        return Stream.concat(ipV4ChannelBufferedReader.lines().skip(1L), ipV6ChannelBufferedReader.lines().skip(1L));
    }

    @Override
    public ProviderKey provider() {
        return MaxmindProviderKey.of();
    }
}

