/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.provider.dbip.parsing;

import com.google.common.base.Splitter;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import technology.dice.dicewhere.api.api.IP;
import technology.dice.dicewhere.api.api.IpInformation;
import technology.dice.dicewhere.api.exceptions.LineParsingException;
import technology.dice.dicewhere.parsing.LineParser;
import technology.dice.dicewhere.parsing.ParsedLine;
import technology.dice.dicewhere.reading.RawLine;
import technology.dice.dicewhere.utils.StringUtils;

public class DbIpIpToCountryLiteCSVLineParser
implements LineParser {
    private static final Splitter splitter = Splitter.on((char)',');

    @Override
    public Stream<ParsedLine> parse(RawLine line, boolean retainOriginalLine) throws LineParsingException {
        try {
            Iterable fieldsIterable = splitter.split((CharSequence)line.getLine());
            Iterator fieldsIterator = fieldsIterable.iterator();
            String rangeStartString = StringUtils.removeQuotes((String)fieldsIterator.next());
            String rangeEndString = StringUtils.removeQuotes((String)fieldsIterator.next());
            String countryCode = (String)fieldsIterator.next();
            InetAddress e = InetAddresses.forString((String)rangeEndString);
            InetAddress s = InetAddresses.forString((String)rangeStartString);
            IP startIp = new IP(s);
            IP endIp = new IP(e);
            return Stream.of(new ParsedLine(startIp, endIp, IpInformation.builder().withCountryCodeAlpha2(StringUtils.removeQuotes(countryCode)).withStartOfRange(startIp).withEndOfRange(endIp).withOriginalLine(retainOriginalLine ? line.getLine() : null).build(), line));
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            throw new LineParsingException(e, line);
        }
    }
}

