/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.api.api;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;

public class IP
implements Comparable<IP>,
Serializable {
    private final byte[] bytes;

    public IP(@Nonnull byte[] bytes) {
        Objects.requireNonNull(bytes);
        this.bytes = bytes;
    }

    public IP(@Nonnull InetAddress ip) {
        this(Objects.requireNonNull(ip).getAddress());
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean isLowerThan(IP other) {
        return this.compareTo(other) < 0;
    }

    public boolean isGreaterThan(IP other) {
        return this.compareTo(other) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IP ip = (IP)o;
        return ip.compareTo(this) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public int compareTo(@Nonnull IP other) {
        Objects.requireNonNull(other);
        byte[] myBytes = this.getBytes();
        byte[] theirBytes = other.getBytes();
        if (myBytes.length < theirBytes.length) {
            return -1;
        }
        if (myBytes.length > theirBytes.length) {
            return 1;
        }
        for (int i = 0; i < myBytes.length; ++i) {
            int theirByteAsInt;
            int myByteAsInt = this.unsignedByteToInt(myBytes[i]);
            if (myByteAsInt == (theirByteAsInt = this.unsignedByteToInt(theirBytes[i]))) continue;
            if (myByteAsInt < theirByteAsInt) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }
}

