/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.downloader.source;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import technology.dice.dicewhere.downloader.destination.FileAcceptor;
import technology.dice.dicewhere.downloader.exception.DownloaderException;
import technology.dice.dicewhere.downloader.files.FileInfo;
import technology.dice.dicewhere.downloader.md5.MD5Checksum;
import technology.dice.dicewhere.downloader.source.FileSource;
import technology.dice.dicewhere.downloader.stream.StreamWithMD5Decorator;

public abstract class BaseUrlSource
implements FileSource {
    protected FileInfo fileInfo;
    protected final URL dataFileLocation;

    protected BaseUrlSource(URL dataFileLocation) {
        this.dataFileLocation = dataFileLocation;
    }

    @Override
    public MD5Checksum produce(FileAcceptor acceptor, boolean noMd5Check) {
        MD5Checksum mD5Checksum;
        block8: {
            HttpURLConnection httpConnection = (HttpURLConnection)this.dataFileLocation.openConnection();
            httpConnection.setRequestMethod("GET");
            StreamWithMD5Decorator is = StreamWithMD5Decorator.of(httpConnection.getInputStream());
            try {
                acceptor.getStreamConsumer(this.fileInfo.getMd5Checksum(), this.fileInfo.getTimestamp(), noMd5Check).consume(is, this.fileInfo.getSize());
                mD5Checksum = is.md5();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    throw new DownloaderException("Could not read file at " + this.fileInfo.getUri().toString(), e);
                }
            }
            is.close();
        }
        return mD5Checksum;
    }
}

