/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.downloader.destination.local;

import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import technology.dice.dicewhere.downloader.destination.FileAcceptor;
import technology.dice.dicewhere.downloader.md5.MD5Checksum;
import technology.dice.dicewhere.downloader.stream.StreamConsumer;

public class LocalFileAcceptor
implements FileAcceptor<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileAcceptor.class);
    public static final int BUFFER = 8192;
    private final Path destination;

    public LocalFileAcceptor(Path destination) {
        this.destination = destination;
    }

    @Override
    public StreamConsumer<Void> getStreamConsumer(MD5Checksum originalFileMd5, Instant originalFileTimestamp, boolean noMd5Check) {
        return (stream, size) -> {
            try {
                Files.createDirectories(this.destination, new FileAttribute[0]);
                LOG.debug("Destination directory created");
            }
            catch (FileAlreadyExistsException e) {
                LOG.debug("Destination directory already exists");
            }
            Files.copy(stream, this.destination, StandardCopyOption.REPLACE_EXISTING);
            if (!noMd5Check && !originalFileMd5.matches(stream.md5())) {
                LOG.error("MD5 mismatch. Deleting destination file");
                Files.delete(this.destination);
            }
            return null;
        };
    }

    @Override
    public boolean destinationExists() {
        return Files.exists(this.destination, new LinkOption[0]);
    }

    @Override
    public boolean destinationWritable() {
        return Files.isWritable(this.findExistingPrefix(this.destination));
    }

    private Path findExistingPrefix(Path destination) {
        Path parent;
        for (parent = destination.getParent(); parent != null && !Files.exists(parent, new LinkOption[0]); parent = parent.getParent()) {
        }
        return parent;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<MD5Checksum> existingFileMd5() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public URI getUri() {
        return URI.create("file://" + this.destination.toString());
    }
}

