/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicefairlink.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import technology.dice.dicefairlink.iterators.SizedIterator;

public class CyclicIterator<T>
implements SizedIterator<T> {
    private final List<T> elements;
    private volatile Iterator<T> iterator;

    protected CyclicIterator(Collection<? extends T> collection) {
        this.elements = Collections.unmodifiableList(new ArrayList<T>(collection));
        this.iterator = this.elements.iterator();
    }

    @Override
    public boolean hasNext() {
        return !this.elements.isEmpty();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public synchronized T next() {
        if (!this.iterator.hasNext()) {
            this.iterator = this.elements.iterator();
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
        }
        T next = this.iterator.next();
        return next;
    }
}

