/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.vlib.ejb.impl;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.contrib.ejb.XCreateException;
import org.apache.tapestry.contrib.ejb.XEJBException;
import org.apache.tapestry.contrib.ejb.XRemoveException;
import org.apache.tapestry.contrib.jdbc.IStatement;
import org.apache.tapestry.contrib.jdbc.StatementAssembly;
import org.apache.tapestry.vlib.ejb.Book;
import org.apache.tapestry.vlib.ejb.BorrowException;
import org.apache.tapestry.vlib.ejb.IBook;
import org.apache.tapestry.vlib.ejb.IBookHome;
import org.apache.tapestry.vlib.ejb.IPerson;
import org.apache.tapestry.vlib.ejb.IPersonHome;
import org.apache.tapestry.vlib.ejb.IPublisher;
import org.apache.tapestry.vlib.ejb.IPublisherHome;
import org.apache.tapestry.vlib.ejb.LoginException;
import org.apache.tapestry.vlib.ejb.Person;
import org.apache.tapestry.vlib.ejb.Publisher;
import org.apache.tapestry.vlib.ejb.RegistrationException;
import org.apache.tapestry.vlib.ejb.SortColumn;
import org.apache.tapestry.vlib.ejb.SortOrdering;

public class OperationsBean
implements SessionBean {
    private static final long serialVersionUID = -3942706099570269035L;
    private transient Context _environment;
    private transient IBookHome _bookHome;
    private transient IPersonHome _personHome;
    private transient IPublisherHome _publisherHome;
    private transient DataSource _dataSource;
    private static final String[] BOOK_SELECT_COLUMNS = new String[]{"book.BOOK_ID", "book.TITLE", "book.DESCRIPTION", "book.ISBN", "owner.PERSON_ID", "owner.FIRST_NAME", "owner.LAST_NAME", "holder.PERSON_ID", "holder.FIRST_NAME", "holder.LAST_NAME", "publisher.PUBLISHER_ID", "publisher.NAME", "book.AUTHOR", "book.HIDDEN", "book.LENDABLE", "book.DATE_ADDED"};
    private static final String[] BOOK_ALIAS_COLUMNS = new String[]{"BOOK book", "PERSON owner", "PERSON holder", "PUBLISHER publisher"};
    private static final String[] BOOK_JOINS = new String[]{"book.OWNER_ID = owner.PERSON_ID", "book.HOLDER_ID = holder.PERSON_ID", "book.PUBLISHER_ID = publisher.PUBLISHER_ID"};
    private static final Map BOOK_SORT_ASCENDING = new HashMap();
    private static final Map BOOK_SORT_DESCENDING = new HashMap();

    public void ejbCreate() {
        try {
            InitialContext initial = new InitialContext();
            this._environment = (Context)initial.lookup("java:comp/env");
        }
        catch (NamingException e) {
            throw new XEJBException("Could not lookup environment.", (Throwable)e);
        }
        try {
            this._dataSource = (DataSource)this._environment.lookup("jdbc/dataSource");
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new XEJBException("Could not lookup data source.", (Throwable)e);
        }
    }

    public void ejbRemove() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext value) {
    }

    public void ejbActivate() {
    }

    public Book borrowBook(Integer bookId, Integer borrowerId) throws FinderException, RemoteException, BorrowException {
        IBookHome bookHome = this.getBookHome();
        IPersonHome personHome = this.getPersonHome();
        IBook book = bookHome.findByPrimaryKey(bookId);
        if (!book.getLendable()) {
            throw new BorrowException("Book may not be borrowed.");
        }
        personHome.findByPrimaryKey(borrowerId);
        personHome.findByPrimaryKey(book.getOwnerId());
        book.setHolderId(borrowerId);
        return this.getBook(bookId);
    }

    public Integer addBook(Map attributes) throws CreateException, RemoteException {
        IBookHome home = this.getBookHome();
        attributes.put("dateAdded", new Timestamp(System.currentTimeMillis()));
        IBook book = home.create(attributes);
        return (Integer)book.getPrimaryKey();
    }

    public Integer addBook(Map attributes, String publisherName) throws CreateException, RemoteException {
        IPublisher publisher = null;
        IPublisherHome publisherHome = this.getPublisherHome();
        try {
            publisher = publisherHome.findByName(publisherName);
        }
        catch (FinderException e) {
            // empty catch block
        }
        if (publisher == null) {
            publisher = publisherHome.create(publisherName);
        }
        attributes.put("publisherId", publisher.getPrimaryKey());
        return this.addBook(attributes);
    }

    public void updateBook(Integer bookId, Map attributes) throws FinderException, RemoteException {
        IBookHome bookHome = this.getBookHome();
        IBook book = bookHome.findByPrimaryKey(bookId);
        book.updateEntityAttributes(attributes);
    }

    public void updateBook(Integer bookId, Map attributes, String publisherName) throws CreateException, FinderException, RemoteException {
        IPublisher publisher = null;
        IPublisherHome publisherHome = this.getPublisherHome();
        try {
            publisher = publisherHome.findByName(publisherName);
        }
        catch (FinderException e) {
            // empty catch block
        }
        if (publisher == null) {
            publisher = publisherHome.create(publisherName);
        }
        attributes.put("publisherId", publisher.getPrimaryKey());
        this.updateBook(bookId, attributes);
    }

    public void updatePerson(Integer personId, Map attributes) throws FinderException, RemoteException {
        IPersonHome home = this.getPersonHome();
        IPerson person = home.findByPrimaryKey(personId);
        person.updateEntityAttributes(attributes);
    }

    public Publisher[] getPublishers() {
        Connection connection = null;
        IStatement statement = null;
        ResultSet set = null;
        ArrayList<Publisher> list = new ArrayList<Publisher>();
        try {
            connection = this.getConnection();
            StatementAssembly assembly = new StatementAssembly();
            assembly.newLine("SELECT PUBLISHER_ID, NAME");
            assembly.newLine("FROM PUBLISHER");
            assembly.newLine("ORDER BY NAME");
            statement = assembly.createStatement(connection);
            set = statement.executeQuery();
            while (set.next()) {
                Integer primaryKey = (Integer)set.getObject(1);
                String name = set.getString(2);
                list.add(new Publisher(primaryKey, name));
            }
            this.close(connection, statement, set);
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new XEJBException("Could not fetch all Publishers.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close(connection, statement, set);
                throw throwable;
            }
        }
        return list.toArray(new Publisher[list.size()]);
    }

    public Person[] getPersons() {
        Connection connection = null;
        IStatement statement = null;
        ResultSet set = null;
        ArrayList<Person> list = new ArrayList<Person>();
        try {
            connection = this.getConnection();
            StatementAssembly assembly = this.buildBasePersonQuery();
            assembly.newLine("ORDER BY LAST_NAME, FIRST_NAME");
            statement = assembly.createStatement(connection);
            set = statement.executeQuery();
            Object[] columns = new Object[7];
            while (set.next()) {
                list.add(this.convertRowToPerson(set, columns));
            }
            this.close(connection, statement, set);
        }
        catch (SQLException ex) {
            try {
                throw new XEJBException("Could not fetch all Persons.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close(connection, statement, set);
                throw throwable;
            }
        }
        return list.toArray(new Person[list.size()]);
    }

    public Person getPerson(Integer personId) throws FinderException {
        Connection connection = null;
        IStatement statement = null;
        ResultSet set = null;
        Person result = null;
        try {
            connection = this.getConnection();
            StatementAssembly assembly = this.buildBasePersonQuery();
            assembly.newLine("WHERE ");
            assembly.add("PERSON_ID = ");
            assembly.addParameter(personId);
            assembly.newLine("ORDER BY LAST_NAME, FIRST_NAME");
            statement = assembly.createStatement(connection);
            set = statement.executeQuery();
            if (!set.next()) {
                throw new FinderException("Person #" + personId + " does not exist.");
            }
            Object[] columns = new Object[7];
            result = this.convertRowToPerson(set, columns);
            this.close(connection, statement, set);
        }
        catch (SQLException ex) {
            try {
                throw new XEJBException("Unable to perform database query.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close(connection, statement, set);
                throw throwable;
            }
        }
        return result;
    }

    public Person login(String email, String password) throws RemoteException, LoginException {
        IPersonHome home = this.getPersonHome();
        IPerson person = null;
        Person result = null;
        try {
            person = home.findByEmail(email);
        }
        catch (FinderException ex) {
            throw new LoginException("Unknown e-mail address.", false);
        }
        if (!person.getPassword().equals(password)) {
            throw new LoginException("Invalid password.", true);
        }
        try {
            result = this.getPerson((Integer)person.getPrimaryKey());
        }
        catch (FinderException ex) {
            throw new LoginException("Could not read person.", false);
        }
        if (result.isLockedOut()) {
            throw new LoginException("You have been locked out of the Virtual Library.", false);
        }
        person.setLastAccess(new Timestamp(System.currentTimeMillis()));
        return result;
    }

    public Map getPersonAttributes(Integer personId) throws FinderException, RemoteException {
        IPersonHome home = this.getPersonHome();
        IPerson person = home.findByPrimaryKey(personId);
        return person.getEntityAttributes();
    }

    public Book getBook(Integer bookId) throws FinderException {
        Connection connection = null;
        IStatement statement = null;
        ResultSet set = null;
        Book result = null;
        try {
            connection = this.getConnection();
            StatementAssembly assembly = this.buildBaseBookQuery();
            assembly.addSep(" AND ");
            assembly.add("book.BOOK_ID = ");
            assembly.addParameter(bookId);
            statement = assembly.createStatement(connection);
            set = statement.executeQuery();
            if (!set.next()) {
                throw new FinderException("Book " + bookId + " does not exist.");
            }
            Object[] columns = new Object[14];
            result = this.convertRowToBook(set, columns);
            this.close(connection, statement, set);
        }
        catch (SQLException ex) {
            try {
                throw new XEJBException("Unable to perform database query.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close(connection, statement, set);
                throw throwable;
            }
        }
        return result;
    }

    public Map getBookAttributes(Integer bookId) throws FinderException, RemoteException {
        IBookHome home = this.getBookHome();
        IBook book = home.findByPrimaryKey(bookId);
        return book.getEntityAttributes();
    }

    public Person registerNewUser(String firstName, String lastName, String email, String password) throws RegistrationException, CreateException, RemoteException {
        if (password == null || password.trim().length() == 0) {
            throw new RegistrationException("Must specify a password.");
        }
        this.validateUniquePerson(firstName, lastName, email);
        IPersonHome home = this.getPersonHome();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("lastName", lastName.trim());
        attributes.put("firstName", firstName.trim());
        attributes.put("email", email.trim());
        attributes.put("password", password.trim());
        attributes.put("lastAccess", new Timestamp(System.currentTimeMillis()));
        IPerson person = home.create(attributes);
        Integer personId = (Integer)person.getPrimaryKey();
        try {
            return this.getPerson(personId);
        }
        catch (FinderException ex) {
            throw new XCreateException("Unable to find newly created Person.", (Throwable)ex);
        }
    }

    public Book deleteBook(Integer bookId) throws RemoveException, RemoteException {
        IBookHome home = this.getBookHome();
        Book result = null;
        try {
            result = this.getBook(bookId);
        }
        catch (FinderException ex) {
            throw new XRemoveException((Throwable)ex);
        }
        home.remove(bookId);
        return result;
    }

    public void transferBooks(Integer newOwnerId, Integer[] bookIds) throws FinderException, RemoteException {
        if (bookIds == null) {
            throw new RemoteException("Must supply non-null list of books to transfer.");
        }
        if (newOwnerId == null) {
            throw new RemoteException("Must provide an owner for the books.");
        }
        IPersonHome personHome = this.getPersonHome();
        personHome.findByPrimaryKey(newOwnerId);
        IBookHome home = this.getBookHome();
        for (int i = 0; i < bookIds.length; ++i) {
            IBook book = home.findByPrimaryKey(bookIds[i]);
            book.setOwnerId(newOwnerId);
        }
    }

    public void updatePublishers(Publisher[] updated, Integer[] deleted) throws FinderException, RemoveException, RemoteException {
        int i;
        IPublisherHome home = this.getPublisherHome();
        if (updated != null) {
            for (i = 0; i < updated.length; ++i) {
                IPublisher publisher = home.findByPrimaryKey(updated[i].getId());
                publisher.setName(updated[i].getName());
            }
        }
        if (deleted != null) {
            for (i = 0; i < deleted.length; ++i) {
                home.remove(deleted[i]);
            }
        }
    }

    public void updatePersons(Person[] updated, Integer[] resetPassword, String newPassword, Integer[] deleted, Integer adminId) throws FinderException, RemoveException, RemoteException {
        int i;
        IPersonHome home = this.getPersonHome();
        int count = Tapestry.size((Object[])updated);
        for (i = 0; i < count; ++i) {
            Person u = updated[i];
            IPerson person = home.findByPrimaryKey(u.getId());
            person.setAdmin(u.isAdmin());
            person.setLockedOut(u.isLockedOut());
        }
        count = Tapestry.size((Object[])resetPassword);
        for (i = 0; i < count; ++i) {
            IPerson person = home.findByPrimaryKey(resetPassword[i]);
            person.setPassword(newPassword);
        }
        count = Tapestry.size((Object[])deleted);
        if (count > 0) {
            this.returnBooksFromDeletedPersons(deleted);
            this.moveBooksFromDeletedPersons(deleted, adminId);
        }
        for (i = 0; i < count; ++i) {
            home.remove(deleted[i]);
        }
    }

    private void returnBooksFromDeletedPersons(Integer[] deletedPersonIds) throws RemoveException {
        StatementAssembly assembly = new StatementAssembly();
        assembly.add("UPDATE BOOK");
        assembly.newLine("SET HOLDER_ID = OWNER_ID");
        assembly.newLine("WHERE HOLDER_ID IN (");
        assembly.addParameterList(deletedPersonIds, ", ");
        assembly.add(")");
        this.executeUpdate(assembly);
    }

    private void moveBooksFromDeletedPersons(Integer[] deletedPersonIds, Integer adminId) throws RemoveException {
        StatementAssembly assembly = new StatementAssembly();
        assembly.add("UPDATE BOOK");
        assembly.newLine("SET OWNER_ID = ");
        assembly.addParameter(adminId);
        assembly.newLine("WHERE OWNER_ID IN (");
        assembly.addParameterList(deletedPersonIds, ", ");
        assembly.add(")");
        this.executeUpdate(assembly);
    }

    private void executeUpdate(StatementAssembly assembly) throws XRemoveException {
        Connection connection = null;
        IStatement statement = null;
        try {
            connection = this.getConnection();
            statement = assembly.createStatement(connection);
            statement.executeUpdate();
            statement.close();
            statement = null;
            connection.close();
            connection = null;
        }
        catch (SQLException ex) {
            throw new XRemoveException("Unable to execute " + assembly + ": " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.close(connection, statement, null);
        }
    }

    protected Book convertRowToBook(ResultSet set, Object[] columns) throws SQLException {
        int column = 1;
        columns[0] = set.getObject(column++);
        columns[1] = set.getString(column++);
        columns[2] = set.getString(column++);
        columns[3] = set.getString(column++);
        columns[4] = set.getObject(column++);
        columns[5] = this.buildName(set.getString(column++), set.getString(column++));
        columns[6] = set.getObject(column++);
        columns[7] = this.buildName(set.getString(column++), set.getString(column++));
        columns[8] = set.getObject(column++);
        columns[9] = set.getString(column++);
        columns[10] = set.getString(column++);
        columns[11] = this.getBoolean(set, column++);
        columns[12] = this.getBoolean(set, column++);
        columns[13] = set.getTimestamp(column++);
        return new Book(columns);
    }

    private String buildName(String firstName, String lastName) {
        if (firstName == null) {
            return lastName;
        }
        return firstName + " " + lastName;
    }

    protected StatementAssembly buildBaseBookQuery() {
        StatementAssembly result = new StatementAssembly();
        result.newLine("SELECT ");
        result.addList(BOOK_SELECT_COLUMNS, ", ");
        result.newLine("FROM ");
        result.addList(BOOK_ALIAS_COLUMNS, ", ");
        result.newLine("WHERE ");
        result.addList(BOOK_JOINS, " AND ");
        return result;
    }

    protected void addSortOrdering(StatementAssembly assembly, SortOrdering ordering) {
        if (ordering == null) {
            assembly.newLine("ORDER BY book.TITLE");
            return;
        }
        Map sorts = ordering.isDescending() ? BOOK_SORT_DESCENDING : BOOK_SORT_ASCENDING;
        String term = (String)sorts.get((Object)ordering.getColumn());
        assembly.newLine("ORDER BY ");
        assembly.add(term);
    }

    protected void addSubstringSearch(StatementAssembly assembly, String column, String value) {
        if (value == null) {
            return;
        }
        String trimmed = value.trim();
        if (trimmed.length() == 0) {
            return;
        }
        assembly.addSep(" AND LOWER(");
        assembly.add(column);
        assembly.add(") LIKE");
        assembly.addParameter("%" + trimmed.toLowerCase() + "%");
    }

    protected void close(Connection connection, IStatement statement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                System.out.println("Exception closing result set.");
                ex.printStackTrace();
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                System.out.println("Exception closing statement.");
                ex.printStackTrace();
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                System.out.println("Exception closing connection.");
                ex.printStackTrace();
            }
        }
    }

    private IPersonHome getPersonHome() {
        if (this._personHome == null) {
            try {
                Object raw = this._environment.lookup("ejb/Person");
                this._personHome = (IPersonHome)PortableRemoteObject.narrow((Object)raw, IPersonHome.class);
            }
            catch (NamingException ex) {
                throw new XEJBException("Could not lookup Person home interface.", (Throwable)ex);
            }
        }
        return this._personHome;
    }

    private IPublisherHome getPublisherHome() {
        if (this._publisherHome == null) {
            try {
                Object raw = this._environment.lookup("ejb/Publisher");
                this._publisherHome = (IPublisherHome)PortableRemoteObject.narrow((Object)raw, IPublisherHome.class);
            }
            catch (NamingException e) {
                throw new XEJBException("Could not lookup Publisher home interface.", (Throwable)e);
            }
        }
        return this._publisherHome;
    }

    private IBookHome getBookHome() {
        if (this._bookHome == null) {
            try {
                Object raw = this._environment.lookup("ejb/Book");
                this._bookHome = (IBookHome)PortableRemoteObject.narrow((Object)raw, IBookHome.class);
            }
            catch (NamingException e) {
                throw new XEJBException("Could not lookup Book home interface.", (Throwable)e);
            }
        }
        return this._bookHome;
    }

    protected Connection getConnection() {
        try {
            return this._dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new XEJBException("Unable to get database connection from pool.", (Throwable)e);
        }
    }

    protected StatementAssembly buildBasePersonQuery() {
        StatementAssembly result = new StatementAssembly();
        result.newLine("SELECT PERSON_ID, FIRST_NAME, LAST_NAME, EMAIL, ");
        result.newLine("   LOCKED_OUT, ADMIN, LAST_ACCESS");
        result.newLine("FROM PERSON");
        return result;
    }

    protected Person convertRowToPerson(ResultSet set, Object[] columns) throws SQLException {
        int column = 1;
        columns[0] = set.getObject(column++);
        columns[1] = set.getString(column++);
        columns[2] = set.getString(column++);
        columns[3] = set.getString(column++);
        columns[4] = this.getBoolean(set, column++);
        columns[5] = this.getBoolean(set, column++);
        columns[6] = set.getTimestamp(column++);
        return new Person(columns);
    }

    private Boolean getBoolean(ResultSet set, int index) throws SQLException {
        return set.getBoolean(index) ? Boolean.TRUE : Boolean.FALSE;
    }

    private void validateUniquePerson(String firstName, String lastName, String email) throws RegistrationException {
        Connection connection = null;
        IStatement statement = null;
        ResultSet set = null;
        String trimmedEmail = email.trim().toLowerCase();
        String trimmedLastName = lastName.trim().toLowerCase();
        String trimmedFirstName = firstName.trim().toLowerCase();
        try {
            connection = this.getConnection();
            StatementAssembly assembly = new StatementAssembly();
            assembly.newLine("SELECT PERSON_ID");
            assembly.newLine("FROM PERSON");
            assembly.newLine("WHERE ");
            assembly.add("LOWER(EMAIL) = ");
            assembly.addParameter(trimmedEmail);
            statement = assembly.createStatement(connection);
            set = statement.executeQuery();
            if (set.next()) {
                throw new RegistrationException("Email address is already in use by another user.");
            }
            this.close(null, statement, set);
            assembly = new StatementAssembly();
            assembly.newLine("SELECT PERSON_ID");
            assembly.newLine("FROM PERSON");
            assembly.newLine("WHERE ");
            assembly.add("LOWER(FIRST_NAME) = ");
            assembly.addParameter(trimmedFirstName);
            assembly.addSep(" AND ");
            assembly.add("LOWER(LAST_NAME) = ");
            assembly.addParameter(trimmedLastName);
            statement = assembly.createStatement(connection);
            set = statement.executeQuery();
            if (set.next()) {
                throw new RegistrationException("Name provided is already in use by another user.");
            }
            this.close(connection, statement, set);
        }
        catch (SQLException e) {
            try {
                throw new RegistrationException("Could not access database: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement, set);
                throw throwable;
            }
        }
    }

    public Book returnBook(Integer bookId) throws RemoteException, FinderException {
        IBookHome bookHome = this.getBookHome();
        IBook book = bookHome.findByPrimaryKey(bookId);
        Integer ownerPK = book.getOwnerId();
        book.setHolderId(ownerPK);
        return this.getBook(bookId);
    }

    static {
        BOOK_SORT_ASCENDING.put(SortColumn.TITLE, "book.TITLE");
        BOOK_SORT_ASCENDING.put(SortColumn.HOLDER, "holder.LAST_NAME, holder.FIRST_NAME");
        BOOK_SORT_ASCENDING.put(SortColumn.OWNER, "owner.FIRST_NAME, owner.LAST_NAME");
        BOOK_SORT_ASCENDING.put(SortColumn.PUBLISHER, "publisher.NAME");
        BOOK_SORT_ASCENDING.put(SortColumn.AUTHOR, "book.AUTHOR");
        BOOK_SORT_DESCENDING.put(SortColumn.TITLE, "book.TITLE DESC");
        BOOK_SORT_DESCENDING.put(SortColumn.HOLDER, "holder.LAST_NAME DESC, holder.FIRST_NAME DESC");
        BOOK_SORT_DESCENDING.put(SortColumn.OWNER, "owner.FIRST_NAME DESC, owner.LAST_NAME DESC");
        BOOK_SORT_DESCENDING.put(SortColumn.PUBLISHER, "publisher.NAME DESC");
        BOOK_SORT_DESCENDING.put(SortColumn.AUTHOR, "book.AUTHOR DESC");
    }
}

