/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.vlib.ejb.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.tapestry.contrib.ejb.XEJBException;

public class KeyAllocatorBean
implements SessionBean {
    private static final long serialVersionUID = -6783018767284081244L;
    private static final String PROPERTY_NAME = "next-key";
    private LinkedList keys;
    private int blockSize = 0;
    private DataSource dataSource;

    public void ejbCreate() {
        Integer blockSizeProperty;
        Context environment;
        try {
            InitialContext initial = new InitialContext();
            environment = (Context)initial.lookup("java:comp/env");
        }
        catch (NamingException ex) {
            throw new XEJBException("Could not lookup environment.", (Throwable)ex);
        }
        try {
            blockSizeProperty = (Integer)environment.lookup("blockSize");
        }
        catch (NamingException ex) {
            throw new XEJBException("Could not lookup blockSize property.", (Throwable)ex);
        }
        this.blockSize = blockSizeProperty;
        try {
            this.dataSource = (DataSource)environment.lookup("jdbc/dataSource");
        }
        catch (NamingException ex) {
            throw new XEJBException("Could not lookup data source.", (Throwable)ex);
        }
        if (this.keys == null) {
            this.keys = new LinkedList();
        }
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext value) {
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public Integer allocateKey() {
        if (this.keys.isEmpty()) {
            this.allocateBlock(1);
        }
        return (Integer)this.keys.removeFirst();
    }

    public Integer[] allocateKeys(int count) {
        if (this.keys.size() < count) {
            this.allocateBlock(count);
        }
        Integer[] result = new Integer[count];
        for (int i = 0; i < count; ++i) {
            result[i] = (Integer)this.keys.removeFirst();
        }
        return result;
    }

    protected void allocateBlock(int count) {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet set = null;
        int allocationCount = Math.max(count, this.blockSize);
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement("select PROP_VALUE from PROP where NAME = ?");
            statement.setString(1, PROPERTY_NAME);
            set = statement.executeQuery();
            set.next();
            int nextKey = set.getInt(1);
            set.close();
            set = null;
            statement.close();
            statement = null;
            for (int i = 0; i < allocationCount; ++i) {
                this.keys.add(new Integer(nextKey++));
            }
            statement = connection.prepareStatement("update PROP\nset PROP_VALUE = ?\nwhere NAME\t = ?");
            statement.setInt(1, nextKey);
            statement.setString(2, PROPERTY_NAME);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new XEJBException("Unable to allocate keys from the database.", (Throwable)ex);
        }
        finally {
            if (set != null) {
                try {
                    set.close();
                }
                catch (SQLException ex) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    protected Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new XEJBException("Unable to get database connection from pool.", (Throwable)ex);
        }
    }
}

