/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.vlib.ejb;

import java.io.Serializable;
import java.sql.Timestamp;

public class Person
implements Serializable {
    private static final long serialVersionUID = 37148852625594728L;
    private Object[] columns;
    public static final int ID_COLUMN = 0;
    public static final int FIRST_NAME_COLUMN = 1;
    public static final int LAST_NAME_COLUMN = 2;
    public static final int EMAIL_COLUMN = 3;
    public static final int LOCKED_OUT_COLUMN = 4;
    public static final int ADMIN_COLUMN = 5;
    public static final int LAST_ACCESS_COLUMN = 6;
    public static final int N_COLUMNS = 7;

    public Person(Object[] columns) {
        if (columns == null) {
            throw new IllegalArgumentException("Must provide a non-null columns.");
        }
        if (columns.length != 7) {
            throw new IllegalArgumentException("Wrong number of columns for a Person.");
        }
        this.columns = new Object[7];
        System.arraycopy(columns, 0, this.columns, 0, 7);
    }

    public Integer getId() {
        return (Integer)this.columns[0];
    }

    public String getFirstName() {
        return (String)this.columns[1];
    }

    public String getLastName() {
        return (String)this.columns[2];
    }

    public String getEmail() {
        return (String)this.columns[3];
    }

    public String getNaturalName() {
        if (this.columns[1] == null) {
            return (String)this.columns[2];
        }
        return (String)this.columns[1] + " " + (String)this.columns[2];
    }

    public Timestamp getLastAccess() {
        return (Timestamp)this.columns[6];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Person[");
        if (this.columns[1] != null) {
            buffer.append((String)this.columns[1]);
            buffer.append(' ');
        }
        buffer.append((String)this.columns[2]);
        buffer.append(']');
        return buffer.toString();
    }

    public boolean isAdmin() {
        return this.getBit(5);
    }

    public void setAdmin(boolean value) {
        this.setBit(5, value);
    }

    public boolean isLockedOut() {
        return this.getBit(4);
    }

    public void setLockedOut(boolean value) {
        this.setBit(4, value);
    }

    private void setBit(int column, boolean value) {
        this.columns[column] = value ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean getBit(int column) {
        Boolean b = (Boolean)this.columns[column];
        return b;
    }
}

