/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.components;

import java.util.Iterator;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.table.components.AbstractTableViewComponent;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableColumnModel;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;

public class TableColumns
extends AbstractTableViewComponent
implements PageDetachListener {
    public static final String TABLE_COLUMN_ARROW_UP_ATTRIBUTE = "org.apache.tapestry.contrib.table.components.TableColumns.arrowUp";
    public static final String TABLE_COLUMN_ARROW_DOWN_ATTRIBUTE = "org.apache.tapestry.contrib.table.components.TableColumns.arrowDown";
    private IBinding m_objColumnBinding = null;
    private IBinding m_objElementBinding = null;
    private IAsset m_objArrowUpAsset;
    private IAsset m_objArrowDownAsset;
    private ITableColumn m_objTableColumn;

    public TableColumns() {
        this.initialize();
    }

    public void pageDetached(PageEvent event) {
        this.initialize();
    }

    protected void initialize() {
        this.m_objArrowUpAsset = null;
        this.m_objArrowDownAsset = null;
    }

    public Iterator getTableColumnIterator() {
        ITableColumnModel objColumnModel = this.getTableModelSource().getTableModel().getColumnModel();
        return objColumnModel.getColumns();
    }

    public ITableColumn getTableColumn() {
        return this.m_objTableColumn;
    }

    public void setTableColumn(ITableColumn tableColumn) {
        this.m_objTableColumn = tableColumn;
        IBinding objColumnBinding = this.getColumnBinding();
        if (objColumnBinding != null) {
            objColumnBinding.setObject((Object)tableColumn);
        }
    }

    public IRender getTableColumnRenderer() {
        return this.getTableColumn().getColumnRenderer(this.getPage().getRequestCycle(), this.getTableModelSource());
    }

    public IBinding getColumnBinding() {
        return this.m_objColumnBinding;
    }

    public void setColumnBinding(IBinding valueBinding) {
        this.m_objColumnBinding = valueBinding;
    }

    public IBinding getElementBinding() {
        return this.m_objElementBinding;
    }

    public void setElementBinding(IBinding elementBinding) {
        this.m_objElementBinding = elementBinding;
    }

    public String getElement() {
        IBinding objElementBinding = this.getElementBinding();
        if (objElementBinding == null || objElementBinding.getObject() == null) {
            return "th";
        }
        return objElementBinding.getString();
    }

    public IAsset getArrowDownAsset() {
        return this.m_objArrowDownAsset;
    }

    public IAsset getArrowUpAsset() {
        return this.m_objArrowUpAsset;
    }

    public void setArrowDownAsset(IAsset arrowDownAsset) {
        this.m_objArrowDownAsset = arrowDownAsset;
    }

    public void setArrowUpAsset(IAsset arrowUpAsset) {
        this.m_objArrowUpAsset = arrowUpAsset;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Object oldValueUp = cycle.getAttribute(TABLE_COLUMN_ARROW_UP_ATTRIBUTE);
        Object oldValueDown = cycle.getAttribute(TABLE_COLUMN_ARROW_DOWN_ATTRIBUTE);
        cycle.setAttribute(TABLE_COLUMN_ARROW_UP_ATTRIBUTE, (Object)this.getArrowUpAsset());
        cycle.setAttribute(TABLE_COLUMN_ARROW_DOWN_ATTRIBUTE, (Object)this.getArrowDownAsset());
        super.renderComponent(writer, cycle);
        cycle.setAttribute(TABLE_COLUMN_ARROW_UP_ATTRIBUTE, oldValueUp);
        cycle.setAttribute(TABLE_COLUMN_ARROW_DOWN_ATTRIBUTE, oldValueDown);
    }
}

