/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.components.Block;
import org.apache.tapestry.contrib.palette.SortMode;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.form.Form;
import org.apache.tapestry.form.FormEventType;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.valid.IValidationDelegate;

public abstract class Palette
extends BaseComponent
implements IFormComponent {
    private static final int DEFAULT_ROWS = 10;
    private static final int MAP_SIZE = 7;
    private static final String DEFAULT_TABLE_CLASS = "tapestry-palette";
    private Map _symbols;
    private IMarkupWriter _availableWriter;
    private IMarkupWriter _selectedWriter;
    private IScript _script;

    protected void finishLoad() {
        this.setSelectedTitleBlock((Block)this.getComponent("defaultSelectedTitleBlock"));
        this.setAvailableTitleBlock((Block)this.getComponent("defaultAvailableTitleBlock"));
        this.setSelectImage(this.getAsset("Select"));
        this.setSelectDisabledImage(this.getAsset("SelectDisabled"));
        this.setDeselectImage(this.getAsset("Deselect"));
        this.setDeselectDisabledImage(this.getAsset("DeselectDisabled"));
        this.setUpImage(this.getAsset("Up"));
        this.setUpDisabledImage(this.getAsset("UpDisabled"));
        this.setDownImage(this.getAsset("Down"));
        this.setDownDisabledImage(this.getAsset("DownDisabled"));
        this.setTableClass(DEFAULT_TABLE_CLASS);
        this.setRows(10);
        this.setSort(SortMode.NONE);
    }

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract IForm getForm();

    public abstract void setForm(IForm var1);

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = Form.get((IRequestCycle)this.getPage().getRequestCycle());
        if (form == null) {
            throw new ApplicationRuntimeException("Palette component must be wrapped by a Form.", (IComponent)this);
        }
        this.setForm(form);
        IValidationDelegate delegate = form.getDelegate();
        if (delegate != null) {
            delegate.setFormComponent((IFormComponent)this);
        }
        this.setName(form.getElementId((IFormComponent)this));
        if (form.isRewinding()) {
            this.handleSubmission(cycle);
        }
        if (!cycle.isRewinding()) {
            this._symbols = new HashMap(7);
            this.runScript(cycle);
            form.addEventHandler(FormEventType.SUBMIT, (String)this._symbols.get("formSubmitFunctionName"));
            this.bufferSelects(writer);
        }
        super.renderComponent(writer, cycle);
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._availableWriter = null;
        this._selectedWriter = null;
        this._symbols = null;
        super.cleanupAfterRender(cycle);
    }

    private void runScript(IRequestCycle cycle) {
        Body body;
        if (this._script == null) {
            IEngine engine = this.getPage().getEngine();
            IScriptSource source = engine.getScriptSource();
            IResourceLocation scriptLocation = this.getSpecification().getSpecificationLocation().getRelativeLocation("Palette.script");
            this._script = source.getScript(scriptLocation);
        }
        if ((body = Body.get((IRequestCycle)cycle)) == null) {
            throw new ApplicationRuntimeException("Palette component must be wrapped by a Body.", (IComponent)this);
        }
        this.setImage(body, cycle, "selectImage", this.getSelectImage());
        this.setImage(body, cycle, "selectDisabledImage", this.getSelectDisabledImage());
        this.setImage(body, cycle, "deselectImage", this.getDeselectImage());
        this.setImage(body, cycle, "deselectDisabledImage", this.getDeselectDisabledImage());
        if (this.isSortUser()) {
            this.setImage(body, cycle, "upImage", this.getUpImage());
            this.setImage(body, cycle, "upDisabledImage", this.getUpDisabledImage());
            this.setImage(body, cycle, "downImage", this.getDownImage());
            this.setImage(body, cycle, "downDisabledImage", this.getDownDisabledImage());
        }
        this._symbols.put("palette", this);
        this._script.execute(cycle, (IScriptProcessor)body, this._symbols);
    }

    private void setImage(Body body, IRequestCycle cycle, String symbolName, IAsset asset) {
        String URL2 = asset.buildURL(cycle);
        String reference = body.getPreloadedImageReference(URL2);
        this._symbols.put(symbolName, reference);
    }

    public Map getSymbols() {
        return this._symbols;
    }

    private void bufferSelects(IMarkupWriter writer) {
        List selected = this.getSelected();
        Set selectedSet = selected == null ? Collections.EMPTY_SET : new HashSet(selected);
        this._selectedWriter = writer.getNestedWriter();
        this._availableWriter = writer.getNestedWriter();
        this._selectedWriter.begin("select");
        this._selectedWriter.attribute("multiple", "multiple");
        this._selectedWriter.attribute("size", this.getRows());
        this._selectedWriter.attribute("name", this.getName());
        this._selectedWriter.println();
        this._availableWriter.begin("select");
        this._availableWriter.attribute("multiple", "multiple");
        this._availableWriter.attribute("size", this.getRows());
        this._availableWriter.attribute("name", (String)this._symbols.get("availableName"));
        this._availableWriter.println();
        IPropertySelectionModel model = this.getModel();
        int count = model.getOptionCount();
        int i = 0;
        while (i < count) {
            IMarkupWriter w = this._availableWriter;
            Object optionValue = model.getOption(i);
            if (selectedSet.contains(optionValue)) {
                w = this._selectedWriter;
            }
            w.begin("option");
            w.attribute("value", model.getValue(i));
            w.print(model.getLabel(i));
            w.end();
            w.println();
            ++i;
        }
        this._selectedWriter.end();
        this._availableWriter.end();
    }

    public IRender getAvailableSelectDelegate() {
        return new IRender(){

            public void render(IMarkupWriter writer, IRequestCycle cycle) {
                if (Palette.this._availableWriter != null) {
                    Palette.this._availableWriter.close();
                }
                Palette.this._availableWriter = null;
            }
        };
    }

    public IRender getSelectedSelectDelegate() {
        return new IRender(){

            public void render(IMarkupWriter writer, IRequestCycle cycle) {
                if (Palette.this._selectedWriter != null) {
                    Palette.this._selectedWriter.close();
                }
                Palette.this._selectedWriter = null;
            }
        };
    }

    private void handleSubmission(IRequestCycle cycle) {
        RequestContext context = cycle.getRequestContext();
        Object[] values = context.getParameters(this.getName());
        int count = Tapestry.size((Object[])values);
        if (count == 0) {
            return;
        }
        ArrayList<Object> selected = new ArrayList<Object>(count);
        IPropertySelectionModel model = this.getModel();
        int i = 0;
        while (i < count) {
            Object value = values[i];
            Object option = model.translateValue((String)value);
            selected.add(option);
            ++i;
        }
        this.setSelected(selected);
    }

    public boolean isSortUser() {
        return this.getSort() == SortMode.USER;
    }

    public String getDisplayName() {
        return null;
    }

    public abstract Block getAvailableTitleBlock();

    public abstract void setAvailableTitleBlock(Block var1);

    public abstract IAsset getDeselectDisabledImage();

    public abstract void setDeselectDisabledImage(IAsset var1);

    public abstract IAsset getDeselectImage();

    public abstract void setDeselectImage(IAsset var1);

    public abstract IAsset getDownDisabledImage();

    public abstract void setDownDisabledImage(IAsset var1);

    public abstract IAsset getDownImage();

    public abstract void setDownImage(IAsset var1);

    public abstract IPropertySelectionModel getModel();

    public abstract int getRows();

    public abstract void setRows(int var1);

    public abstract IAsset getSelectDisabledImage();

    public abstract void setSelectDisabledImage(IAsset var1);

    public abstract Block getSelectedTitleBlock();

    public abstract void setSelectedTitleBlock(Block var1);

    public abstract IAsset getSelectImage();

    public abstract void setSelectImage(IAsset var1);

    public abstract SortMode getSort();

    public abstract void setSort(SortMode var1);

    public abstract void setTableClass(String var1);

    public abstract IAsset getUpDisabledImage();

    public abstract void setUpDisabledImage(IAsset var1);

    public abstract IAsset getUpImage();

    public abstract void setUpImage(IAsset var1);

    public boolean isDisabled() {
        return false;
    }

    public abstract List getSelected();

    public abstract void setSelected(List var1);
}

