/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.tapestry.contrib.jdbc.BooleanParameter;
import org.apache.tapestry.contrib.jdbc.DoubleParameter;
import org.apache.tapestry.contrib.jdbc.FloatParameter;
import org.apache.tapestry.contrib.jdbc.IParameter;
import org.apache.tapestry.contrib.jdbc.IStatement;
import org.apache.tapestry.contrib.jdbc.IntegerParameter;
import org.apache.tapestry.contrib.jdbc.LongParameter;
import org.apache.tapestry.contrib.jdbc.ObjectParameter;
import org.apache.tapestry.contrib.jdbc.ParameterizedStatement;
import org.apache.tapestry.contrib.jdbc.ShortParameter;
import org.apache.tapestry.contrib.jdbc.SimpleStatement;
import org.apache.tapestry.contrib.jdbc.StringParameter;
import org.apache.tapestry.contrib.jdbc.TimestampParameter;

public class StatementAssembly {
    private StringBuffer _buffer = new StringBuffer();
    private static final String NULL = "NULL";
    public static final String SEP = ", ";
    private List _parameters;
    private int _lineLength;
    private int _maxLineLength = 80;
    private int _indent = 5;

    public StatementAssembly() {
    }

    public StatementAssembly(int maxLineLength, int indent) {
        this._maxLineLength = maxLineLength;
        this._indent = indent;
    }

    public void clear() {
        this._buffer.setLength(0);
        this._lineLength = 0;
        if (this._parameters != null) {
            this._parameters.clear();
        }
    }

    public int getMaxLineLength() {
        return this._maxLineLength;
    }

    public int getIndent() {
        return this._indent;
    }

    public void add(String text) {
        int textLength = text.length();
        if (this._lineLength + textLength > this._maxLineLength) {
            this._buffer.append('\n');
            int i = 0;
            while (i < this._indent) {
                this._buffer.append(' ');
                ++i;
            }
            this._lineLength = this._indent;
        }
        this._buffer.append(text);
        this._lineLength += textLength;
    }

    public void add(short value) {
        this.add(Short.toString(value));
    }

    public void add(int value) {
        this.add(Integer.toString(value));
    }

    public void add(long value) {
        this.add(Long.toString(value));
    }

    public void add(float value) {
        this.add(Float.toString(value));
    }

    public void add(double value) {
        this.add(Double.toString(value));
    }

    public void addParameter(Date date) {
        if (date == null) {
            this.add(NULL);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        Date adjusted = calendar.getTime();
        Timestamp timestamp = new Timestamp(adjusted.getTime());
        this.addParameter(timestamp);
    }

    public void addSep(String text) {
        this._buffer.append(text);
        this._lineLength += text.length();
    }

    public void newLine() {
        if (this._buffer.length() != 0) {
            this._buffer.append('\n');
        }
        this._lineLength = 0;
    }

    public void newLine(String text) {
        if (this._buffer.length() != 0) {
            this._buffer.append('\n');
        }
        this._buffer.append(text);
        this._lineLength = text.length();
    }

    public void addList(String[] items, String separator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(separator);
            }
            this.add(items[i]);
            ++i;
        }
    }

    public void addParameterList(int[] items, String separator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(separator);
            }
            this.addParameter(items[i]);
            ++i;
        }
    }

    public void addParameterList(Integer[] items, String separator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(separator);
            }
            this.addParameter(items[i]);
            ++i;
        }
    }

    public void addParameterList(long[] items, String separator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(separator);
            }
            this.addParameter(items[i]);
            ++i;
        }
    }

    public void addParameterList(Long[] items, String separator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(separator);
            }
            this.addParameter(items[i]);
            ++i;
        }
    }

    public void addParameterList(String[] items, String separator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(separator);
            }
            this.addParameter(items[i]);
            ++i;
        }
    }

    public void addParameterList(double[] items, String separator) {
        int i = 0;
        while (i < items.length) {
            if (i > 0) {
                this.addSep(separator);
            }
            this.addParameter(items[i]);
            ++i;
        }
    }

    public void addParameter(Object value) {
        if (value == null) {
            this.add(NULL);
        } else {
            this.addParameter(new ObjectParameter(value));
        }
    }

    public void addParameter(Timestamp timestamp) {
        if (timestamp == null) {
            this.add(NULL);
        } else {
            this.addParameter(new TimestampParameter(timestamp));
        }
    }

    public void addParameter(String value) {
        if (value == null) {
            this.add(NULL);
        } else {
            this.addParameter(new StringParameter(value));
        }
    }

    public void addParameter(int value) {
        this.addParameter(new IntegerParameter(value));
    }

    public void addParameter(Integer value) {
        if (value == null) {
            this.add(NULL);
        } else {
            this.addParameter((int)value);
        }
    }

    public void addParameter(long value) {
        this.addParameter(new LongParameter(value));
    }

    public void addParameter(Long value) {
        if (value == null) {
            this.add(NULL);
        } else {
            this.addParameter((long)value);
        }
    }

    public void addParameter(float value) {
        this.addParameter(new FloatParameter(value));
    }

    public void addParameter(Float value) {
        if (value == null) {
            this.add(NULL);
        } else {
            this.addParameter(value.floatValue());
        }
    }

    public void addParameter(double value) {
        this.addParameter(new DoubleParameter(value));
    }

    public void addParameter(Double value) {
        if (value == null) {
            this.add(NULL);
        } else {
            this.addParameter((double)value);
        }
    }

    public void addParameter(short value) {
        this.addParameter(new ShortParameter(value));
    }

    public void addParameter(Short value) {
        if (value == null) {
            this.add(NULL);
        } else {
            this.addParameter((short)value);
        }
    }

    public void addParameter(boolean value) {
        this.addParameter(value ? BooleanParameter.TRUE : BooleanParameter.FALSE);
    }

    public void addParameter(Boolean value) {
        if (value == null) {
            this.add(NULL);
        } else {
            this.addParameter((boolean)value);
        }
    }

    private void addParameter(IParameter parameter) {
        if (this._parameters == null) {
            this._parameters = new ArrayList();
        }
        this._parameters.add(parameter);
        this.add("?");
    }

    public IStatement createStatement(Connection connection) throws SQLException {
        String sql = this._buffer.toString();
        if (this._parameters == null || this._parameters.isEmpty()) {
            return new SimpleStatement(sql, connection);
        }
        return new ParameterizedStatement(sql, connection, this._parameters);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("StatementAssembly@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append("[SQL=\n<");
        buffer.append((Object)this._buffer);
        buffer.append("\n>");
        if (this._parameters != null) {
            int count = this._parameters.size();
            int i = 0;
            while (i < count) {
                Object parameter = this._parameters.get(i);
                buffer.append(" ?");
                buffer.append(i + 1);
                buffer.append('=');
                buffer.append(parameter);
                ++i;
            }
        }
        buffer.append(']');
        return buffer.toString();
    }
}

