/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.spring.view;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.tangram.spring.view.SpringRequestParameterAccess;
import org.tangram.spring.view.ViewHandler;
import org.tangram.util.SystemUtils;
import org.tangram.view.RequestParameterAccess;
import org.tangram.view.ViewContext;
import org.tangram.view.ViewContextFactory;
import org.tangram.view.ViewUtilities;

public class SpringViewUtilities
implements ViewUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(SpringViewUtilities.class);
    @Inject
    private ViewContextFactory viewContextFactory;
    @Inject
    private ViewHandler viewHandler;
    public static final View NOT_FOUND_DUMMY = new View(){

        public String getContentType() {
            return null;
        }

        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        }
    };

    public ViewContextFactory getViewContextFactory() {
        return this.viewContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestParameterAccess createParameterAccess(HttpServletRequest request) throws Exception {
        HttpServletRequest httpServletRequest = request;
        synchronized (httpServletRequest) {
            Object result = (RequestParameterAccess)SystemUtils.convert((Object)request.getAttribute("parameter.access"));
            if (result == null) {
                result = new SpringRequestParameterAccess(request);
                request.setAttribute("parameter.access", result);
            }
            return result;
        }
    }

    public static ModelAndView createModelAndView(ViewContext viewContext) {
        return viewContext == null ? null : new ModelAndView(viewContext.getViewName(), viewContext.getModel());
    }

    public void render(Writer writer, Map<String, Object> model, String view) throws IOException {
        block5: {
            ServletRequest request = (ServletRequest)model.get("request");
            ServletResponse response = (ServletResponse)model.get("response");
            ViewContext vc = this.viewContextFactory.createViewContext(model, view);
            ModelAndView mav = SpringViewUtilities.createModelAndView(vc);
            View effectiveView = mav.getView();
            LOG.debug("render() effectiveView={}", (Object)effectiveView);
            try {
                if (effectiveView == null) {
                    String viewName = mav.getViewName();
                    if (viewName == null) {
                        viewName = "NULL";
                    }
                    effectiveView = this.viewHandler.resolveView(viewName, mav.getModel(), Locale.getDefault(), request);
                }
                if (writer != null) {
                    writer.flush();
                }
                LOG.debug("render() model={}", (Object)mav.getModel());
                LOG.debug("render({}) effectiveView={}", (Object)mav.getViewName(), (Object)effectiveView);
                effectiveView.render(mav.getModel(), (HttpServletRequest)request, (HttpServletResponse)response);
            }
            catch (Exception e) {
                LOG.error("render() #" + view, (Throwable)e);
                if (writer == null) break block5;
                writer.write(e.getLocalizedMessage());
            }
        }
    }

    public void render(Writer writer, Object bean, String view, ServletRequest request, ServletResponse response) throws IOException {
        this.render(writer, this.viewContextFactory.createModel(bean, request, response), view);
    }
}

