/*
 * Decompiled with CFR 0.152.
 */
package org.tangram.spring;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;
import org.tangram.spring.StreamingMultipartFile;

public class StreamingMultipartResolver
implements MultipartResolver {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingMultipartResolver.class);
    public static final String ERROR = "errorcode";
    private long maxUploadSize = 50000L;

    public long getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public void setMaxUploadSize(long maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public boolean isMultipart(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileSizeMax(this.maxUploadSize);
        String encoding = this.determineEncoding(request);
        HashMap<String, String[]> multipartParameters = new HashMap<String, String[]>();
        LinkedMultiValueMap multipartFiles = new LinkedMultiValueMap();
        HashMap<String, String> multipartFileContentTypes = new HashMap<String, String>();
        try {
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String name = item.getFieldName();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    String value = Streams.asString((InputStream)stream, (String)encoding);
                    String[] curParam = (String[])multipartParameters.get(name);
                    if (curParam == null) {
                        multipartParameters.put(name, new String[]{value});
                        continue;
                    }
                    String[] newParam = StringUtils.addStringToArray((String[])curParam, (String)value);
                    multipartParameters.put(name, newParam);
                    continue;
                }
                try {
                    StreamingMultipartFile file = new StreamingMultipartFile(item);
                    multipartFiles.add((Object)name, (Object)file);
                    multipartFileContentTypes.put(name, file.getContentType());
                }
                catch (IOException e) {
                    LOG.warn("({})", (Object)e.getCause().getMessage(), (Object)e);
                    MultipartFile file = new MultipartFile(){

                        public String getName() {
                            return "";
                        }

                        public String getOriginalFilename() {
                            return e.getCause().getMessage();
                        }

                        public String getContentType() {
                            return StreamingMultipartResolver.ERROR;
                        }

                        public boolean isEmpty() {
                            return true;
                        }

                        public long getSize() {
                            return 0L;
                        }

                        public byte[] getBytes() throws IOException {
                            return new byte[0];
                        }

                        public InputStream getInputStream() throws IOException {
                            return null;
                        }

                        public void transferTo(File file) throws IOException, IllegalStateException {
                            throw new UnsupportedOperationException("NYI", e);
                        }
                    };
                    multipartFiles.add((Object)name, (Object)file);
                    multipartFileContentTypes.put(name, file.getContentType());
                }
            }
        }
        catch (IOException | FileUploadException e) {
            throw new MultipartException("Error uploading a file", e);
        }
        return new DefaultMultipartHttpServletRequest(request, (MultiValueMap)multipartFiles, multipartParameters, multipartFileContentTypes);
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
    }

    protected String determineEncoding(HttpServletRequest request) {
        String encoding = request.getCharacterEncoding();
        return encoding == null ? "UTF-8" : encoding;
    }
}

